/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.CacheFilterEnum;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;

public class VisorIdleVerifyDumpTaskArg
extends VisorIdleVerifyTaskArg {
    private static final long serialVersionUID = 0L;

    public VisorIdleVerifyDumpTaskArg() {
    }

    public VisorIdleVerifyDumpTaskArg(Set<String> caches, Set<String> excludeCaches, boolean skipZeros, CacheFilterEnum cacheFilterEnum, boolean checkCrc) {
        super(caches, excludeCaches, skipZeros, cacheFilterEnum, checkCrc);
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        super.writeExternalData(out);
        out.writeBoolean(this.skipZeros());
        if (this.instanceOfCurrentClass()) {
            U.writeEnum(out, this.cacheFilterEnum());
            U.writeCollection(out, this.excludeCaches());
            out.writeBoolean(this.checkCrc());
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalData(protoVer, in);
        this.skipZeros(in.readBoolean());
        if (this.instanceOfCurrentClass()) {
            if (protoVer >= 2) {
                this.cacheFilterEnum(CacheFilterEnum.fromOrdinal(in.readByte()));
            } else {
                this.cacheFilterEnum(CacheFilterEnum.DEFAULT);
            }
            if (protoVer >= 2) {
                this.excludeCaches(U.readSet(in));
            }
            if (protoVer >= 3) {
                this.checkCrc(in.readBoolean());
            }
        }
    }

    @Override
    public byte getProtocolVersion() {
        return (byte)Math.max(2, super.getProtocolVersion());
    }

    @Override
    public String toString() {
        return S.toString(VisorIdleVerifyDumpTaskArg.class, this);
    }

    private boolean instanceOfCurrentClass() {
        return VisorIdleVerifyDumpTaskArg.class == this.getClass();
    }
}

