/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.log.snapshot.PullSnapshotTaskDescriptor;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullSnapshotHintService {
    private static final Logger logger = LoggerFactory.getLogger(PullSnapshotHintService.class);
    private DataGroupMember member;
    private ScheduledExecutorService service;
    private ConcurrentLinkedDeque<PullSnapshotHint> hints;

    public PullSnapshotHintService(DataGroupMember member) {
        this.member = member;
        this.hints = new ConcurrentLinkedDeque();
    }

    public void start() {
        this.service = IoTDBThreadPoolFactory.newScheduledThreadPool((int)1, (String)"PullSnapshotHint");
        this.service.scheduleAtFixedRate(this::sendHints, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.service == null) {
            return;
        }
        this.service.shutdownNow();
        try {
            this.service.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("{}: PullSnapshotHintService exiting interrupted", (Object)this.member.getName());
        }
        this.service = null;
    }

    public void registerHint(PullSnapshotTaskDescriptor descriptor) {
        PullSnapshotHint hint = new PullSnapshotHint();
        hint.partitionGroup = descriptor.getPreviousHolders();
        hint.receivers = new PartitionGroup(hint.partitionGroup);
        hint.slots = descriptor.getSlots();
        this.hints.add(hint);
    }

    private void sendHints() {
        Iterator<PullSnapshotHint> iterator = this.hints.iterator();
        while (iterator.hasNext()) {
            PullSnapshotHint hint = iterator.next();
            Iterator iter = hint.receivers.iterator();
            while (iter.hasNext()) {
                Node receiver = (Node)iter.next();
                if (!this.member.getMetaGroupMember().getPartitionTable().getAllNodes().contains(receiver)) {
                    iter.remove();
                    continue;
                }
                try {
                    boolean result;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: start to send hint to target group {}, receiver {}, slot is {} and other {}", new Object[]{this.member.getName(), hint.partitionGroup, receiver, hint.slots.get(0), hint.slots.size() - 1});
                    }
                    if (!(result = this.sendHint(receiver, hint))) continue;
                    iter.remove();
                }
                catch (TException e) {
                    logger.warn("Cannot send pull snapshot hint to {}", (Object)receiver);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Sending hint to {} interrupted", (Object)receiver);
                }
            }
            if (!hint.receivers.isEmpty()) continue;
            iterator.remove();
        }
    }

    private boolean sendHint(Node receiver, PullSnapshotHint hint) throws TException, InterruptedException {
        boolean result = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.sendHintsAsync(receiver, hint) : this.sendHintSync(receiver, hint);
        return result;
    }

    private boolean sendHintsAsync(Node receiver, PullSnapshotHint hint) throws TException, InterruptedException {
        AsyncDataClient asyncDataClient = (AsyncDataClient)this.member.getAsyncClient(receiver);
        if (asyncDataClient == null) {
            return false;
        }
        return SyncClientAdaptor.onSnapshotApplied(asyncDataClient, hint.getHeader(), hint.slots);
    }

    private boolean sendHintSync(Node receiver, PullSnapshotHint hint) throws TException {
        SyncDataClient syncDataClient = null;
        try {
            syncDataClient = (SyncDataClient)this.member.getSyncClient(receiver);
            if (syncDataClient == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = syncDataClient.onSnapshotApplied(hint.getHeader(), hint.slots);
            return bl;
        }
        catch (TException e) {
            syncDataClient.close();
            throw e;
        }
        finally {
            if (syncDataClient != null) {
                syncDataClient.returnSelf();
            }
        }
    }

    private static class PullSnapshotHint {
        private PartitionGroup receivers;
        private PartitionGroup partitionGroup;
        private List<Integer> slots;

        private PullSnapshotHint() {
        }

        public RaftNode getHeader() {
            return this.partitionGroup.getHeader();
        }

        public int getRaftId() {
            return this.receivers.getRaftId();
        }
    }
}

