/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetChildNodeNextLevelPathHandler
implements AsyncMethodCallback<Set<String>> {
    private static final Logger logger = LoggerFactory.getLogger(GetChildNodeNextLevelPathHandler.class);
    private Node contact;
    private AtomicReference<Set<String>> result;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(Set<String> resp) {
        logger.info("Received child node next level path from {}", (Object)this.contact);
        AtomicReference<Set<String>> atomicReference = this.result;
        synchronized (atomicReference) {
            this.result.set(resp);
            this.result.notifyAll();
        }
    }

    public void onError(Exception exception) {
        logger.warn("Cannot get child node next level path from {}, because", (Object)this.contact, (Object)exception);
    }

    public void setResponse(AtomicReference<Set<String>> response) {
        this.result = response;
    }

    public void setContact(Node contact) {
        this.contact = contact;
    }
}

