/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.raft;

import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.server.raft.RaftServiceHandler;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.RPCServiceException;
import org.apache.iotdb.db.service.thrift.ThriftService;
import org.apache.iotdb.db.service.thrift.ThriftServiceThread;
import org.apache.thrift.TBaseAsyncProcessor;
import org.apache.thrift.server.TServerEventHandler;

public abstract class AbstractRaftService
extends ThriftService {
    public void initThriftServiceThread(String daemonThreadName, String clientThreadName, ThriftServiceThread.ServerType serverType) throws IllegalAccessException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        try {
            this.thriftServiceThread = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? new ThriftServiceThread((TBaseAsyncProcessor)this.processor, this.getID().getName(), clientThreadName, this.getBindIP(), this.getBindPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new RaftServiceHandler(), false, ClusterDescriptor.getInstance().getConfig().getConnectionTimeoutInMS(), config.getThriftMaxFrameSize(), serverType) : new ThriftServiceThread(this.processor, this.getID().getName(), clientThreadName, this.getBindIP(), this.getBindPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new RaftServiceHandler(), false);
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(daemonThreadName);
    }

    public String getBindIP() {
        return ClusterDescriptor.getInstance().getConfig().getInternalIp();
    }
}

