/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import java.nio.ByteBuffer;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.exception.AddSelfException;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.exception.LogExecutionException;
import org.apache.iotdb.cluster.exception.PartitionTableUnavailableException;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.apache.iotdb.cluster.rpc.thrift.AddNodeResponse;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.CheckStatusResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.StartUpStatus;
import org.apache.iotdb.cluster.rpc.thrift.TNodeStatus;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.service.BaseAsyncService;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaAsyncService
extends BaseAsyncService
implements TSMetaService.AsyncIface {
    private static final String ERROR_MSG_META_NOT_READY = "The metadata not is not ready.";
    private static final Logger logger = LoggerFactory.getLogger(MetaAsyncService.class);
    private MetaGroupMember metaGroupMember;

    public MetaAsyncService(MetaGroupMember metaGroupMember) {
        super(metaGroupMember);
        this.metaGroupMember = metaGroupMember;
    }

    public void appendEntry(AppendEntryRequest request, AsyncMethodCallback resultHandler) {
        if (!this.metaGroupMember.isReady() && this.metaGroupMember.getPartitionTable() == null) {
            logger.debug("This node is blind to the cluster and cannot accept logs");
            resultHandler.onComplete((Object)-4L);
            return;
        }
        super.appendEntry(request, (AsyncMethodCallback<Long>)resultHandler);
    }

    public void addNode(Node node, StartUpStatus startUpStatus, AsyncMethodCallback<AddNodeResponse> resultHandler) {
        if (!this.metaGroupMember.isReady()) {
            logger.debug(ERROR_MSG_META_NOT_READY);
            resultHandler.onError((Exception)((Object)new TException(ERROR_MSG_META_NOT_READY)));
            return;
        }
        AddNodeResponse addNodeResponse = null;
        try {
            addNodeResponse = this.metaGroupMember.addNode(node, startUpStatus);
        }
        catch (AddSelfException | CheckConsistencyException | LogExecutionException e) {
            resultHandler.onError(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            resultHandler.onError((Exception)e);
        }
        if (addNodeResponse != null) {
            resultHandler.onComplete((Object)addNodeResponse);
            return;
        }
        if (this.member.getCharacter() == NodeCharacter.FOLLOWER && this.member.getLeader() != null && !ClusterConstant.EMPTY_NODE.equals(this.member.getLeader())) {
            logger.info("Forward the join request of {} to leader {}", (Object)node, (Object)this.member.getLeader());
            if (this.forwardAddNode(node, startUpStatus, resultHandler)) {
                return;
            }
        }
        resultHandler.onError((Exception)new LeaderUnknownException(this.member.getAllNodes()));
    }

    public void sendSnapshot(SendSnapshotRequest request, AsyncMethodCallback<Void> resultHandler) {
        try {
            this.metaGroupMember.receiveSnapshot(request);
        }
        catch (Exception e) {
            resultHandler.onError(e);
            return;
        }
        resultHandler.onComplete(null);
    }

    public void checkStatus(StartUpStatus startUpStatus, AsyncMethodCallback<CheckStatusResponse> resultHandler) {
        CheckStatusResponse response = ClusterUtils.checkStatus(startUpStatus, this.metaGroupMember.getNewStartUpStatus());
        resultHandler.onComplete((Object)response);
    }

    private boolean forwardAddNode(Node node, StartUpStatus startUpStatus, AsyncMethodCallback<AddNodeResponse> resultHandler) {
        TSMetaService.AsyncClient client = (TSMetaService.AsyncClient)this.metaGroupMember.getAsyncClient(this.metaGroupMember.getLeader());
        if (client != null) {
            try {
                client.addNode(node, startUpStatus, resultHandler);
                return true;
            }
            catch (TException e) {
                logger.warn("Cannot connect to node {}", (Object)node, (Object)e);
            }
        }
        return false;
    }

    public void queryNodeStatus(AsyncMethodCallback<TNodeStatus> resultHandler) {
        resultHandler.onComplete((Object)new TNodeStatus());
    }

    public void checkAlive(AsyncMethodCallback<Node> resultHandler) {
        resultHandler.onComplete((Object)this.metaGroupMember.getThisNode());
    }

    public void collectMigrationStatus(AsyncMethodCallback<ByteBuffer> resultHandler) {
        resultHandler.onComplete((Object)ClusterUtils.serializeMigrationStatus(this.metaGroupMember.collectMigrationStatus()));
    }

    public void removeNode(Node node, AsyncMethodCallback<Long> resultHandler) {
        long result;
        if (!this.metaGroupMember.isReady()) {
            logger.debug(ERROR_MSG_META_NOT_READY);
            resultHandler.onError((Exception)((Object)new TException(ERROR_MSG_META_NOT_READY)));
            return;
        }
        try {
            result = this.metaGroupMember.removeNode(node);
        }
        catch (CheckConsistencyException | LogExecutionException | PartitionTableUnavailableException e) {
            logger.error("Can not remove node {}", (Object)node, (Object)e);
            resultHandler.onError(e);
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Can not remove node {}", (Object)node, (Object)e);
            resultHandler.onError((Exception)e);
            return;
        }
        if (result != Long.MIN_VALUE) {
            resultHandler.onComplete((Object)result);
            return;
        }
        if (this.metaGroupMember.getCharacter() == NodeCharacter.FOLLOWER && this.metaGroupMember.getLeader() != null) {
            logger.info("Forward the node removal request of {} to leader {}", (Object)node, (Object)this.metaGroupMember.getLeader());
            if (this.forwardRemoveNode(node, resultHandler)) {
                return;
            }
        }
        resultHandler.onError((Exception)new LeaderUnknownException(this.metaGroupMember.getAllNodes()));
    }

    private boolean forwardRemoveNode(Node node, AsyncMethodCallback<Long> resultHandler) {
        TSMetaService.AsyncClient client = (TSMetaService.AsyncClient)this.metaGroupMember.getAsyncClient(this.metaGroupMember.getLeader());
        if (client != null) {
            try {
                client.removeNode(node, resultHandler);
                return true;
            }
            catch (TException e) {
                logger.warn("Cannot connect to node {}", (Object)node, (Object)e);
            }
        }
        return false;
    }

    public void exile(ByteBuffer removeNodeLogBuffer, AsyncMethodCallback<Void> resultHandler) {
        logger.info("{}: start to exile.", (Object)this.name);
        removeNodeLogBuffer.get();
        RemoveNodeLog removeNodeLog = new RemoveNodeLog();
        removeNodeLog.deserialize(removeNodeLogBuffer);
        this.metaGroupMember.getPartitionTable().deserialize(removeNodeLog.getPartitionTable());
        this.metaGroupMember.applyRemoveNode(removeNodeLog);
        resultHandler.onComplete(null);
    }

    public void handshake(Node sender, AsyncMethodCallback<Void> resultHandler) {
        this.metaGroupMember.handleHandshake(sender);
        resultHandler.onComplete(null);
    }
}

