/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.iotdb.tsfile.write.chunk.TimeChunkWriter;
import org.apache.iotdb.tsfile.write.chunk.ValueChunkWriter;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignedChunkGroupWriterImpl
implements IChunkGroupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AlignedChunkGroupWriterImpl.class);
    private final String deviceId;
    private Map<String, ValueChunkWriter> valueChunkWriterMap = new LinkedHashMap<String, ValueChunkWriter>();
    private TimeChunkWriter timeChunkWriter;
    private Set<String> writenMeasurementSet = new HashSet<String>();
    private long lastTime = -1L;

    public AlignedChunkGroupWriterImpl(String deviceId) {
        this.deviceId = deviceId;
        String timeMeasurementId = "";
        CompressionType compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        TSEncoding tsEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        Encoder encoder = TSEncodingBuilder.getEncodingBuilder(tsEncoding).getEncoder(timeType);
        this.timeChunkWriter = new TimeChunkWriter(timeMeasurementId, compressionType, tsEncoding, encoder);
    }

    @Override
    public void tryToAddSeriesWriter(MeasurementSchema measurementSchema) throws IOException {
        if (!this.valueChunkWriterMap.containsKey(measurementSchema.getMeasurementId())) {
            ValueChunkWriter valueChunkWriter = new ValueChunkWriter(measurementSchema.getMeasurementId(), measurementSchema.getCompressor(), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getValueEncoder());
            this.valueChunkWriterMap.put(measurementSchema.getMeasurementId(), valueChunkWriter);
            this.tryToAddEmptyPageAndData(valueChunkWriter);
        }
    }

    @Override
    public void tryToAddSeriesWriter(List<MeasurementSchema> measurementSchemas) throws IOException {
        for (MeasurementSchema schema : measurementSchemas) {
            if (this.valueChunkWriterMap.containsKey(schema.getMeasurementId())) continue;
            ValueChunkWriter valueChunkWriter = new ValueChunkWriter(schema.getMeasurementId(), schema.getCompressor(), schema.getType(), schema.getEncodingType(), schema.getValueEncoder());
            this.valueChunkWriterMap.put(schema.getMeasurementId(), valueChunkWriter);
            this.tryToAddEmptyPageAndData(valueChunkWriter);
        }
    }

    @Override
    public int write(long time, List<DataPoint> data) throws WriteProcessException, IOException {
        this.checkIsHistoryData("", time);
        block8: for (DataPoint point : data) {
            this.writenMeasurementSet.add(point.getMeasurementId());
            boolean isNull = point.getValue() == null;
            ValueChunkWriter valueChunkWriter = this.valueChunkWriterMap.get(point.getMeasurementId());
            switch (point.getType()) {
                case BOOLEAN: {
                    valueChunkWriter.write(time, (Boolean)point.getValue(), isNull);
                    continue block8;
                }
                case INT32: {
                    valueChunkWriter.write(time, (Integer)point.getValue(), isNull);
                    continue block8;
                }
                case INT64: {
                    valueChunkWriter.write(time, (Long)point.getValue(), isNull);
                    continue block8;
                }
                case FLOAT: {
                    valueChunkWriter.write(time, ((Float)point.getValue()).floatValue(), isNull);
                    continue block8;
                }
                case DOUBLE: {
                    valueChunkWriter.write(time, (Double)point.getValue(), isNull);
                    continue block8;
                }
                case TEXT: {
                    valueChunkWriter.write(time, (Binary)point.getValue(), isNull);
                    continue block8;
                }
            }
            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{point.getType()}));
        }
        this.writeEmptyDataInOneRow(time);
        this.timeChunkWriter.write(time);
        this.lastTime = time;
        if (this.checkPageSizeAndMayOpenANewPage()) {
            this.writePageToPageBuffer();
        }
        return 1;
    }

    @Override
    public int write(Tablet tablet) throws WriteProcessException, IOException {
        int pointCount = 0;
        List<MeasurementSchema> measurementSchemas = tablet.getSchemas();
        for (int row = 0; row < tablet.rowSize; ++row) {
            long time = tablet.timestamps[row];
            this.checkIsHistoryData("", time);
            block9: for (int columnIndex = 0; columnIndex < measurementSchemas.size(); ++columnIndex) {
                this.writenMeasurementSet.add(measurementSchemas.get(columnIndex).getMeasurementId());
                boolean isNull = false;
                if (tablet.bitMaps != null && tablet.bitMaps[columnIndex] != null && tablet.bitMaps[columnIndex].isMarked(row)) {
                    isNull = true;
                }
                ValueChunkWriter valueChunkWriter = this.valueChunkWriterMap.get(measurementSchemas.get(columnIndex).getMeasurementId());
                switch (measurementSchemas.get(columnIndex).getType()) {
                    case BOOLEAN: {
                        valueChunkWriter.write(time, ((boolean[])tablet.values[columnIndex])[row], isNull);
                        continue block9;
                    }
                    case INT32: {
                        valueChunkWriter.write(time, ((int[])tablet.values[columnIndex])[row], isNull);
                        continue block9;
                    }
                    case INT64: {
                        valueChunkWriter.write(time, ((long[])tablet.values[columnIndex])[row], isNull);
                        continue block9;
                    }
                    case FLOAT: {
                        valueChunkWriter.write(time, ((float[])tablet.values[columnIndex])[row], isNull);
                        continue block9;
                    }
                    case DOUBLE: {
                        valueChunkWriter.write(time, ((double[])tablet.values[columnIndex])[row], isNull);
                        continue block9;
                    }
                    case TEXT: {
                        valueChunkWriter.write(time, ((Binary[])tablet.values[columnIndex])[row], isNull);
                        continue block9;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{measurementSchemas.get(columnIndex).getType()}));
                    }
                }
            }
            this.writeEmptyDataInOneRow(time);
            this.timeChunkWriter.write(time);
            this.lastTime = time;
            if (this.checkPageSizeAndMayOpenANewPage()) {
                this.writePageToPageBuffer();
            }
            ++pointCount;
        }
        return pointCount;
    }

    @Override
    public long flushToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        LOG.debug("start flush device id:{}", (Object)this.deviceId);
        this.sealAllChunks();
        long currentChunkGroupSize = this.getCurrentChunkGroupSize();
        this.timeChunkWriter.writeToFileWriter(tsfileWriter);
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            valueChunkWriter.writeToFileWriter(tsfileWriter);
        }
        return currentChunkGroupSize;
    }

    @Override
    public long updateMaxGroupMemSize() {
        long bufferSize = this.timeChunkWriter.estimateMaxSeriesMemSize();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            bufferSize += valueChunkWriter.estimateMaxSeriesMemSize();
        }
        return bufferSize;
    }

    @Override
    public long getCurrentChunkGroupSize() {
        long size = this.timeChunkWriter.getCurrentChunkSize();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            size += valueChunkWriter.getCurrentChunkSize();
        }
        return size;
    }

    public void tryToAddEmptyPageAndData(ValueChunkWriter valueChunkWriter) throws IOException {
        for (int i = 0; i < this.timeChunkWriter.getNumOfPages(); ++i) {
            valueChunkWriter.writeEmptyPageToPageBuffer();
        }
        for (long i = 0L; i < this.timeChunkWriter.getPageWriter().getStatistics().getCount(); ++i) {
            valueChunkWriter.write(0L, 0, true);
        }
    }

    private void writeEmptyDataInOneRow(long time) {
        for (Map.Entry<String, ValueChunkWriter> entry : this.valueChunkWriterMap.entrySet()) {
            if (this.writenMeasurementSet.contains(entry.getKey())) continue;
            entry.getValue().write(time, 0, true);
        }
        this.writenMeasurementSet.clear();
    }

    private boolean checkPageSizeAndMayOpenANewPage() {
        if (this.timeChunkWriter.checkPageSizeAndMayOpenANewPage()) {
            return true;
        }
        for (ValueChunkWriter writer : this.valueChunkWriterMap.values()) {
            if (!writer.checkPageSizeAndMayOpenANewPage()) continue;
            return true;
        }
        return false;
    }

    private void writePageToPageBuffer() {
        this.timeChunkWriter.writePageToPageBuffer();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            valueChunkWriter.writePageToPageBuffer();
        }
    }

    private void sealAllChunks() {
        this.timeChunkWriter.sealCurrentPage();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            valueChunkWriter.sealCurrentPage();
        }
    }

    private void checkIsHistoryData(String measurementId, long time) throws WriteProcessException {
        if (time <= this.lastTime) {
            throw new WriteProcessException("Not allowed to write out-of-order data in timeseries " + this.deviceId + "." + measurementId + ", time should later than " + this.lastTime);
        }
    }

    public List<String> getMeasurements() {
        return new ArrayList<String>(this.valueChunkWriterMap.keySet());
    }

    public Long getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }
}

