/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.concurrent.threadpool;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.iotdb.db.concurrent.threadpool.WrappedSingleThreadExecutorServiceMBean;
import org.apache.iotdb.db.service.JMXService;

public class WrappedSingleThreadExecutorService
implements ExecutorService,
WrappedSingleThreadExecutorServiceMBean {
    private final String mbeanName;
    ExecutorService service;

    public WrappedSingleThreadExecutorService(ExecutorService service, String mbeanName) {
        this.service = service;
        this.mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.threadpool", "type", mbeanName);
        JMXService.registerMBean(this, this.mbeanName);
    }

    @Override
    public void shutdown() {
        this.service.shutdown();
        JMXService.deregisterMBean(this.mbeanName);
    }

    @Override
    public List<Runnable> shutdownNow() {
        JMXService.deregisterMBean(this.mbeanName);
        return this.service.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.service.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.service.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.service.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.service.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.service.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.service.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.service.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.service.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.service.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.service.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.service.execute(command);
    }
}

