/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

public class TsFileLock {
    private volatile int readCnt;
    private volatile int writeCnt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLock() {
        TsFileLock tsFileLock = this;
        synchronized (tsFileLock) {
            while (this.writeCnt > 0) {
                try {
                    this.wait(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            ++this.readCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUnlock() {
        TsFileLock tsFileLock = this;
        synchronized (tsFileLock) {
            if (this.readCnt > 0) {
                --this.readCnt;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLock() {
        TsFileLock tsFileLock = this;
        synchronized (tsFileLock) {
            try {
                while (this.writeCnt > 0 || this.readCnt > 0) {
                    this.wait(1L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ++this.writeCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUnlock() {
        TsFileLock tsFileLock = this;
        synchronized (tsFileLock) {
            if (this.writeCnt > 0) {
                --this.writeCnt;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWriteLock() {
        TsFileLock tsFileLock = this;
        synchronized (tsFileLock) {
            if (this.writeCnt > 0 || this.readCnt > 0) {
                return false;
            }
            ++this.writeCnt;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReadLock() {
        TsFileLock tsFileLock = this;
        synchronized (tsFileLock) {
            if (this.writeCnt > 0) {
                return false;
            }
            ++this.readCnt;
            return true;
        }
    }
}

