/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.index.common.IndexType;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateIndexPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class CreateIndexOperator
extends Operator {
    private final List<PartialPath> paths;
    private Map<String, String> props;
    private long time;
    private IndexType indexType;

    public CreateIndexOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.CREATE_INDEX;
        this.paths = new ArrayList<PartialPath>();
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    public void addPath(PartialPath path) {
        this.paths.add(path);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        return new CreateIndexPlan(this.paths, this.props, this.time, this.indexType);
    }
}

