/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.fill;

import java.util.Set;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class ValueFill
extends IFill
implements Cloneable {
    private String value;
    private TsPrimitiveType tsPrimitiveType;
    private String singleStringValue;

    public ValueFill(String singleStringValue) {
        this.singleStringValue = singleStringValue;
    }

    public ValueFill(String value, TSDataType dataType) {
        this.value = value;
        this.dataType = dataType;
        this.parseTsPrimitiveType();
    }

    @Override
    public IFill copy() {
        return (IFill)this.clone();
    }

    public Object clone() {
        ValueFill valueFill = null;
        try {
            valueFill = (ValueFill)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return valueFill;
    }

    @Override
    public void configureFill(PartialPath path, TSDataType dataType, long queryTime, Set<String> deviceMeasurements, QueryContext context) {
        this.queryStartTime = queryTime;
    }

    @Override
    public TimeValuePair getFillResult() {
        if (this.tsPrimitiveType != null) {
            switch (this.dataType) {
                case BOOLEAN: 
                case INT32: 
                case INT64: 
                case FLOAT: 
                case DOUBLE: 
                case TEXT: {
                    return new TimeValuePair(this.queryStartTime, this.tsPrimitiveType);
                }
            }
            throw new UnSupportedDataTypeException("Unsupported data type:" + this.dataType);
        }
        return null;
    }

    public TimeValuePair getSpecifiedFillResult(TSDataType dataType) throws QueryProcessException {
        switch (dataType) {
            case BOOLEAN: {
                if (this.singleStringValue.equals("true")) {
                    return new TimeValuePair(this.queryStartTime, (TsPrimitiveType)new TsPrimitiveType.TsBoolean(true));
                }
                if (this.singleStringValue.equals("false")) {
                    return new TimeValuePair(this.queryStartTime, (TsPrimitiveType)new TsPrimitiveType.TsBoolean(false));
                }
                return null;
            }
            case INT32: {
                return new TimeValuePair(this.queryStartTime, (TsPrimitiveType)new TsPrimitiveType.TsInt(Integer.parseInt(this.singleStringValue)));
            }
            case INT64: {
                return new TimeValuePair(this.queryStartTime, (TsPrimitiveType)new TsPrimitiveType.TsLong(Long.parseLong(this.singleStringValue)));
            }
            case FLOAT: {
                return new TimeValuePair(this.queryStartTime, (TsPrimitiveType)new TsPrimitiveType.TsFloat(Float.parseFloat(this.singleStringValue)));
            }
            case DOUBLE: {
                return new TimeValuePair(this.queryStartTime, (TsPrimitiveType)new TsPrimitiveType.TsDouble(Double.parseDouble(this.singleStringValue)));
            }
            case TEXT: {
                return new TimeValuePair(this.queryStartTime, (TsPrimitiveType)new TsPrimitiveType.TsBinary(Binary.valueOf((String)this.singleStringValue)));
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type:" + dataType);
    }

    @Override
    void constructFilter() {
    }

    private void parseTsPrimitiveType() {
        switch (this.dataType) {
            case BOOLEAN: {
                this.tsPrimitiveType = new TsPrimitiveType.TsBoolean(Boolean.parseBoolean(this.value));
                break;
            }
            case INT32: {
                this.tsPrimitiveType = new TsPrimitiveType.TsInt(Integer.parseInt(this.value));
                break;
            }
            case INT64: {
                this.tsPrimitiveType = new TsPrimitiveType.TsLong(Long.parseLong(this.value));
                break;
            }
            case FLOAT: {
                this.tsPrimitiveType = new TsPrimitiveType.TsFloat(Float.parseFloat(this.value));
                break;
            }
            case DOUBLE: {
                this.tsPrimitiveType = new TsPrimitiveType.TsDouble(Double.parseDouble(this.value));
                break;
            }
            case TEXT: {
                this.tsPrimitiveType = new TsPrimitiveType.TsBinary(Binary.valueOf((String)this.value));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("Unsupported data type:" + this.dataType);
            }
        }
    }
}

