/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.pool;

import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.rescon.AbstractPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTaskManager
extends AbstractPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryTaskManager.class);

    private QueryTaskManager() {
        int threadCnt = Math.min(Runtime.getRuntime().availableProcessors(), IoTDBDescriptor.getInstance().getConfig().getConcurrentQueryThread());
        this.pool = IoTDBThreadPoolFactory.newFixedThreadPool(threadCnt, ThreadName.QUERY_SERVICE.getName());
    }

    public static QueryTaskManager getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getName() {
        return "query task";
    }

    @Override
    public void start() {
        if (this.pool == null) {
            int threadCnt = Math.min(Runtime.getRuntime().availableProcessors(), IoTDBDescriptor.getInstance().getConfig().getConcurrentQueryThread());
            this.pool = IoTDBThreadPoolFactory.newFixedThreadPool(threadCnt, ThreadName.QUERY_SERVICE.getName());
        }
    }

    @Override
    public void stop() {
        if (this.pool != null) {
            this.close();
            this.pool = null;
        }
    }

    private static class InstanceHolder {
        private static QueryTaskManager instance = new QueryTaskManager();

        private InstanceHolder() {
        }
    }
}

