/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.api.customizer.parameter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.unary.FunctionExpression;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class UDFParameters {
    private final List<Expression> expressions;
    private final List<PartialPath> paths;
    private final Map<String, String> attributes;
    private final List<TSDataType> dataTypes;

    public UDFParameters(FunctionExpression functionExpression, Map<Expression, TSDataType> expressionDataTypeMap) throws QueryProcessException {
        this.expressions = functionExpression.getExpressions();
        this.paths = functionExpression.getPaths();
        this.attributes = functionExpression.getFunctionAttributes();
        this.dataTypes = new ArrayList<TSDataType>();
        for (Expression expression : this.expressions) {
            this.dataTypes.add(expressionDataTypeMap.get(expression));
        }
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<TSDataType> getDataTypes() throws MetadataException {
        return this.dataTypes;
    }

    public PartialPath getPath(int index) {
        return this.paths.get(index);
    }

    public TSDataType getDataType(int index) throws MetadataException {
        return this.dataTypes.get(index);
    }

    public boolean hasAttribute(String attributeKey) {
        return this.attributes.containsKey(attributeKey);
    }

    public String getString(String key) {
        return this.attributes.get(key);
    }

    public Boolean getBoolean(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public Integer getInt(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public Long getLong(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public Float getFloat(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Float.valueOf(Float.parseFloat(value));
    }

    public Double getDouble(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Double.valueOf(Double.parseDouble(value));
    }

    public String getStringOrDefault(String key, String defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBooleanOrDefault(String key, boolean defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public int getIntOrDefault(String key, int defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long getLongOrDefault(String key, long defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public float getFloatOrDefault(String key, float defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Float.parseFloat(value);
    }

    public double getDoubleOrDefault(String key, double defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Double.parseDouble(value);
    }
}

