/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.transformer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.transformer.Transformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class ArithmeticBinaryTransformer
extends Transformer {
    private final LayerPointReader leftPointReader;
    private final LayerPointReader rightPointReader;

    protected ArithmeticBinaryTransformer(LayerPointReader leftPointReader, LayerPointReader rightPointReader) {
        this.leftPointReader = leftPointReader;
        this.rightPointReader = rightPointReader;
    }

    @Override
    public boolean isConstantPointReader() {
        return this.leftPointReader.isConstantPointReader() && this.rightPointReader.isConstantPointReader();
    }

    @Override
    protected boolean cacheValue() throws QueryProcessException, IOException {
        if (!this.leftPointReader.next() || !this.rightPointReader.next()) {
            return false;
        }
        if (!this.cacheTime()) {
            return false;
        }
        if (this.leftPointReader.isCurrentNull() || this.rightPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            this.cachedDouble = this.evaluate(ArithmeticBinaryTransformer.castCurrentValueToDoubleOperand(this.leftPointReader), ArithmeticBinaryTransformer.castCurrentValueToDoubleOperand(this.rightPointReader));
        }
        this.leftPointReader.readyForNext();
        this.rightPointReader.readyForNext();
        return true;
    }

    private boolean cacheTime() throws IOException, QueryProcessException {
        if (this.leftPointReader.isConstantPointReader() && this.rightPointReader.isConstantPointReader()) {
            return true;
        }
        if (this.leftPointReader.isConstantPointReader()) {
            this.cachedTime = this.rightPointReader.currentTime();
            return true;
        }
        if (this.rightPointReader.isConstantPointReader()) {
            this.cachedTime = this.leftPointReader.currentTime();
            return true;
        }
        long leftTime = this.leftPointReader.currentTime();
        long rightTime = this.rightPointReader.currentTime();
        while (leftTime != rightTime) {
            if (leftTime < rightTime) {
                this.leftPointReader.readyForNext();
                if (!this.leftPointReader.next()) {
                    return false;
                }
                leftTime = this.leftPointReader.currentTime();
                continue;
            }
            this.rightPointReader.readyForNext();
            if (!this.rightPointReader.next()) {
                return false;
            }
            rightTime = this.rightPointReader.currentTime();
        }
        this.cachedTime = leftTime;
        return true;
    }

    protected abstract double evaluate(double var1, double var3);

    private static double castCurrentValueToDoubleOperand(LayerPointReader layerPointReader) throws IOException, QueryProcessException {
        switch (layerPointReader.getDataType()) {
            case INT32: {
                return layerPointReader.currentInt();
            }
            case INT64: {
                return layerPointReader.currentLong();
            }
            case FLOAT: {
                return layerPointReader.currentFloat();
            }
            case DOUBLE: {
                return layerPointReader.currentDouble();
            }
        }
        throw new QueryProcessException("Unsupported data type: " + layerPointReader.getDataType().toString());
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.DOUBLE;
    }
}

