/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.influxdb.InfluxDBException;

public class DataTypeUtils {
    public static final String MSG_UNSUPPORTED_DATA_TYPE = "Unsupported data type:";
    private static final byte TYPE_NULL = -2;

    public static TSDataType normalTypeToTSDataType(Object value) {
        if (value instanceof Boolean) {
            return TSDataType.BOOLEAN;
        }
        if (value instanceof Integer) {
            return TSDataType.INT32;
        }
        if (value instanceof Long) {
            return TSDataType.INT64;
        }
        if (value instanceof Double) {
            return TSDataType.DOUBLE;
        }
        if (value instanceof String) {
            return TSDataType.TEXT;
        }
        throw new InfluxDBException("Data type not valid: " + value.toString());
    }

    public static org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus RPCStatusToInfluxDBTSStatus(TSStatus status) {
        org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus tsStatus = new org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus();
        tsStatus.setCode(status.code);
        tsStatus.setMessage(status.message);
        return tsStatus;
    }

    public static ByteBuffer getValueBuffer(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        ByteBuffer buffer = ByteBuffer.allocate(DataTypeUtils.calculateLength(types, values));
        DataTypeUtils.putValues(types, values, buffer);
        return buffer;
    }

    private static int calculateLength(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        int res = 0;
        block8: for (int i = 0; i < types.size(); ++i) {
            ++res;
            switch (types.get(i)) {
                case BOOLEAN: {
                    ++res;
                    continue block8;
                }
                case INT32: {
                    res += 4;
                    continue block8;
                }
                case INT64: {
                    res += 8;
                    continue block8;
                }
                case FLOAT: {
                    res += 4;
                    continue block8;
                }
                case DOUBLE: {
                    res += 8;
                    continue block8;
                }
                case TEXT: {
                    res += 4;
                    res += ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET).length;
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException(MSG_UNSUPPORTED_DATA_TYPE + types.get(i));
                }
            }
        }
        return res;
    }

    private static void putValues(List<TSDataType> types, List<Object> values, ByteBuffer buffer) throws IoTDBConnectionException {
        block8: for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) {
                ReadWriteIOUtils.write((byte)-2, (ByteBuffer)buffer);
                continue;
            }
            ReadWriteIOUtils.write((TSDataType)types.get(i), (ByteBuffer)buffer);
            switch (types.get(i)) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)values.get(i)).floatValue(), (ByteBuffer)buffer);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    byte[] bytes = ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET);
                    ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)buffer);
                    buffer.put(bytes);
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException(MSG_UNSUPPORTED_DATA_TYPE + types.get(i));
                }
            }
        }
        buffer.flip();
    }
}

