/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.pipe.agent.task.PipeTask;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;

public class PipeTaskManager {
    private final Map<PipeStaticMeta, Map<Integer, PipeTask>> pipeMap = new HashMap<PipeStaticMeta, Map<Integer, PipeTask>>();
    private volatile int leaderRegionCount = 0;

    public synchronized void addPipeTask(PipeStaticMeta pipeStaticMeta, int consensusGroupId, PipeTask pipeTask) {
        Map regionId2PipeTask = this.pipeMap.computeIfAbsent(pipeStaticMeta, k -> new HashMap());
        regionId2PipeTask.put(consensusGroupId, pipeTask);
        this.leaderRegionCount = Math.max(this.leaderRegionCount, regionId2PipeTask.size());
    }

    public synchronized void addPipeTasks(PipeStaticMeta pipeStaticMeta, Map<Integer, PipeTask> pipeTasks) {
        Map regionId2PipeTask = this.pipeMap.computeIfAbsent(pipeStaticMeta, k -> new HashMap());
        regionId2PipeTask.putAll(pipeTasks);
        this.leaderRegionCount = Math.max(this.leaderRegionCount, regionId2PipeTask.size());
    }

    public synchronized PipeTask removePipeTask(PipeStaticMeta pipeStaticMeta, int consensusGroupId) {
        Map<Integer, PipeTask> consensusGroupIdPipeTaskMap = this.pipeMap.get(pipeStaticMeta);
        if (consensusGroupIdPipeTaskMap != null) {
            return consensusGroupIdPipeTaskMap.remove(consensusGroupId);
        }
        return null;
    }

    public synchronized Map<Integer, PipeTask> removePipeTasks(PipeStaticMeta pipeStaticMeta) {
        return this.pipeMap.remove(pipeStaticMeta);
    }

    public synchronized PipeTask getPipeTask(PipeStaticMeta pipeStaticMeta, int consensusGroupId) {
        Map<Integer, PipeTask> consensusGroupIdPipeTaskMap = this.pipeMap.get(pipeStaticMeta);
        if (consensusGroupIdPipeTaskMap != null) {
            return consensusGroupIdPipeTaskMap.get(consensusGroupId);
        }
        return null;
    }

    public synchronized Map<Integer, PipeTask> getPipeTasks(PipeStaticMeta pipeStaticMeta) {
        return this.pipeMap.get(pipeStaticMeta);
    }

    public synchronized boolean hasPipeTaskInConsensusGroup(int consensusGroupId) {
        return this.pipeMap.values().stream().anyMatch(consensusGroupId2PipeTask -> consensusGroupId2PipeTask.containsKey(consensusGroupId));
    }

    public int getLeaderRegionCount() {
        return this.leaderRegionCount;
    }
}

