/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class IoTDBPipePattern
extends PipePattern {
    private final PartialPath patternPartialPath;

    public IoTDBPipePattern(String pattern) {
        super(pattern);
        try {
            this.patternPartialPath = new PartialPath(this.getPattern());
        }
        catch (IllegalPathException e) {
            throw new PipeException("Illegal IoTDBPipePattern: " + this.getPattern(), (Throwable)e);
        }
    }

    public static <T> List<T> applyIndexesOnList(int[] filteredIndexes, List<T> originalList) {
        return Objects.nonNull(originalList) ? Arrays.stream(filteredIndexes).mapToObj(originalList::get).collect(Collectors.toList()) : null;
    }

    @Override
    public String getDefaultPattern() {
        return "root.**";
    }

    @Override
    public boolean isLegal() {
        if (!this.pattern.startsWith("root")) {
            return false;
        }
        try {
            PathUtils.isLegalPath(this.pattern);
            return true;
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean coversDb(String db) {
        try {
            return this.patternPartialPath.include(new PartialPath(db, "**"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean coversDevice(String device) {
        try {
            return this.patternPartialPath.include(new PartialPath(device, "*"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean mayOverlapWithDevice(String device) {
        try {
            return this.patternPartialPath.matchPrefixPath(new PartialPath(device));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean mayOverlapWithDb(String db) {
        try {
            return this.patternPartialPath.overlapWith(new PartialPath(db + ".**"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean matchesMeasurement(String device, String measurement) {
        if (Objects.isNull(measurement) || measurement.isEmpty()) {
            return false;
        }
        try {
            return this.patternPartialPath.matchFullPath(new PartialPath(device, measurement));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    public boolean matchPrefixPath(String path) {
        return this.mayOverlapWithDevice(path);
    }

    public boolean matchDevice(String devicePath) {
        try {
            return this.patternPartialPath.overlapWith(new PartialPath(devicePath, "*"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    public boolean matchTailNode(String tailNode) {
        return !this.isFullPath() || this.patternPartialPath.getTailNode().equals(tailNode);
    }

    public List<PartialPath> getIntersection(PartialPath partialPath) {
        if (this.isFullPath()) {
            return partialPath.matchFullPath(this.patternPartialPath) ? Collections.singletonList(this.patternPartialPath) : Collections.emptyList();
        }
        return partialPath.intersectWithPrefixPattern(this.patternPartialPath);
    }

    public PathPatternTree getIntersection(PathPatternTree patternTree) {
        PathPatternTree thisPatternTree = new PathPatternTree();
        thisPatternTree.appendPathPattern(this.patternPartialPath);
        thisPatternTree.constructTree();
        return patternTree.intersectWithFullPathPrefixTree(thisPatternTree);
    }

    public boolean isPrefix() {
        return PathPatternUtil.isMultiLevelMatchWildcard(this.patternPartialPath.getTailNode()) && !new PartialPath(Arrays.copyOfRange(this.patternPartialPath.getNodes(), 0, this.patternPartialPath.getNodeLength() - 1)).hasWildcard();
    }

    public boolean isFullPath() {
        return !this.patternPartialPath.hasWildcard();
    }

    public boolean mayMatchMultipleTimeSeriesInOneDevice() {
        return PathPatternUtil.hasWildcard(this.patternPartialPath.getTailNode());
    }

    @Override
    public String toString() {
        return "IoTDBPipePattern" + super.toString();
    }
}

