/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.queue;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentIterableLinkedQueue<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentIterableLinkedQueue.class);
    private final LinkedListNode<E> pilotNode = new LinkedListNode(null);
    private LinkedListNode<E> firstNode = this.pilotNode;
    private LinkedListNode<E> lastNode = this.pilotNode;
    private long firstIndex = 0L;
    private long tailIndex = 0L;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Condition hasNextCondition = this.lock.writeLock().newCondition();
    private final Set<DynamicIterator> iteratorSet = Collections.newSetFromMap(new ConcurrentHashMap());

    public void add(E e) {
        if (e == null) {
            throw new IllegalArgumentException("Null element is not allowed.");
        }
        LinkedListNode newNode = new LinkedListNode(e);
        this.lock.writeLock().lock();
        try {
            if (this.firstNode == this.pilotNode) {
                this.firstIndex = this.tailIndex;
                this.firstNode = newNode;
                ((LinkedListNode)this.pilotNode).next = newNode;
            }
            ++this.tailIndex;
            ((LinkedListNode)this.lastNode).next = newNode;
            this.lastNode = newNode;
            this.hasNextCondition.signalAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tryRemoveBefore(long newFirstIndex) {
        this.lock.writeLock().lock();
        try {
            for (DynamicIterator iterator2 : this.iteratorSet) {
                newFirstIndex = Math.min(newFirstIndex, iterator2.getNextIndex());
            }
            newFirstIndex = Math.max(newFirstIndex, this.firstIndex);
            newFirstIndex = Math.min(newFirstIndex, this.tailIndex);
            LinkedListNode currentNode = this.firstNode;
            while (this.firstIndex < newFirstIndex) {
                LinkedListNode nextNode = currentNode.next;
                currentNode.data = null;
                currentNode.next = null;
                currentNode = nextNode;
                ++this.firstIndex;
            }
            this.firstNode = currentNode;
            if (this.firstNode != this.pilotNode) {
                ((LinkedListNode)this.pilotNode).next = (LinkedListNode)this.firstNode;
            }
            if (this.firstNode == null) {
                this.firstNode = this.pilotNode;
                this.lastNode = this.pilotNode;
            }
            this.iteratorSet.forEach(iterator -> {
                if (((DynamicIterator)iterator).nextIndex == this.firstIndex) {
                    ((DynamicIterator)iterator).currentNode = this.pilotNode;
                }
            });
            this.hasNextCondition.signalAll();
            long l = this.firstIndex;
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            ImmutableSet.copyOf(this.iteratorSet).forEach(DynamicIterator::close);
            this.tryRemoveBefore(this.tailIndex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.firstIndex == this.tailIndex;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long size() {
        this.lock.readLock().lock();
        try {
            long l = this.tailIndex - this.firstIndex;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getFirstIndex() {
        this.lock.readLock().lock();
        try {
            long l = this.firstIndex;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getTailIndex() {
        this.lock.readLock().lock();
        try {
            long l = this.tailIndex;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setFirstIndex(long firstIndex) {
        this.lock.writeLock().lock();
        try {
            this.firstIndex = firstIndex;
            if (this.tailIndex < firstIndex) {
                this.tailIndex = firstIndex;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNextIndexValid(long nextIndex) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.firstIndex <= nextIndex && nextIndex <= this.tailIndex;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean hasAnyIterators() {
        return !this.iteratorSet.isEmpty();
    }

    public DynamicIterator iterateFrom(long offset) {
        DynamicIterator iterator = new DynamicIterator(offset);
        this.iteratorSet.add(iterator);
        return iterator;
    }

    public DynamicIterator iterateFromEarliest() {
        return this.iterateFrom(Long.MIN_VALUE);
    }

    public DynamicIterator iterateFromLatest() {
        return this.iterateFrom(Long.MAX_VALUE);
    }

    private static class LinkedListNode<E> {
        private E data;
        private LinkedListNode<E> next;

        private LinkedListNode(E data) {
            this.data = data;
            this.next = null;
        }
    }

    public class DynamicIterator
    implements Iterator<E>,
    Closeable {
        private LinkedListNode<E> currentNode;
        private long nextIndex;
        private volatile boolean isClosed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DynamicIterator(long nextIndex) {
            ConcurrentIterableLinkedQueue.this.lock.writeLock().lock();
            try {
                if (ConcurrentIterableLinkedQueue.this.tailIndex <= nextIndex) {
                    this.currentNode = ConcurrentIterableLinkedQueue.this.lastNode;
                    this.nextIndex = ConcurrentIterableLinkedQueue.this.tailIndex;
                    return;
                }
                this.currentNode = ConcurrentIterableLinkedQueue.this.pilotNode;
                if (ConcurrentIterableLinkedQueue.this.firstIndex < nextIndex) {
                    long step = nextIndex - ConcurrentIterableLinkedQueue.this.firstIndex;
                    for (long i = 0L; i < step; ++i) {
                        this.next();
                    }
                } else {
                    nextIndex = ConcurrentIterableLinkedQueue.this.firstIndex;
                }
                this.nextIndex = nextIndex;
            }
            finally {
                ConcurrentIterableLinkedQueue.this.lock.writeLock().unlock();
            }
        }

        @Override
        public E next() {
            return this.next(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E next(long waitTimeMillis) {
            ConcurrentIterableLinkedQueue.this.lock.writeLock().lock();
            try {
                while (!this.hasNext()) {
                    if (this.isClosed) {
                        LOGGER.warn("Calling next() to a closed iterator, will return null.");
                        Object e = null;
                        return e;
                    }
                    if (ConcurrentIterableLinkedQueue.this.hasNextCondition.await(waitTimeMillis, TimeUnit.MILLISECONDS)) continue;
                    Object e = null;
                    return e;
                }
                this.currentNode = this.currentNode.next;
                ++this.nextIndex;
                Object object = this.currentNode.data;
                return object;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Interrupted while waiting for next element.", (Throwable)e);
                Object e2 = null;
                return e2;
            }
            finally {
                ConcurrentIterableLinkedQueue.this.lock.writeLock().unlock();
            }
        }

        @Override
        public boolean hasNext() {
            ConcurrentIterableLinkedQueue.this.lock.readLock().lock();
            try {
                boolean bl = !this.isClosed && this.currentNode.next != null;
                return bl;
            }
            finally {
                ConcurrentIterableLinkedQueue.this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long seek(long newNextIndex) {
            ConcurrentIterableLinkedQueue.this.lock.writeLock().lock();
            try {
                long step;
                long oldNextIndex;
                if (this.isClosed) {
                    long l = -1L;
                    return l;
                }
                newNextIndex = Math.max(ConcurrentIterableLinkedQueue.this.firstIndex, Math.min(ConcurrentIterableLinkedQueue.this.tailIndex, newNextIndex));
                if (newNextIndex < (oldNextIndex = this.nextIndex)) {
                    this.currentNode = ConcurrentIterableLinkedQueue.this.pilotNode;
                    this.nextIndex = ConcurrentIterableLinkedQueue.this.firstIndex;
                    step = newNextIndex - ConcurrentIterableLinkedQueue.this.firstIndex;
                    for (long i = 0L; i < step; ++i) {
                        this.next();
                    }
                } else {
                    step = newNextIndex - oldNextIndex;
                    for (long i = 0L; i < step; ++i) {
                        this.next();
                    }
                }
                long l = this.nextIndex;
                return l;
            }
            finally {
                ConcurrentIterableLinkedQueue.this.lock.writeLock().unlock();
            }
        }

        @Override
        public void close() {
            ConcurrentIterableLinkedQueue.this.lock.writeLock().lock();
            try {
                this.isClosed = true;
                ConcurrentIterableLinkedQueue.this.iteratorSet.remove(this);
                ConcurrentIterableLinkedQueue.this.hasNextCondition.signalAll();
            }
            finally {
                ConcurrentIterableLinkedQueue.this.lock.writeLock().unlock();
            }
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public long getNextIndex() {
            ConcurrentIterableLinkedQueue.this.lock.readLock().lock();
            try {
                long l = this.isClosed ? -1L : this.nextIndex;
                return l;
            }
            finally {
                ConcurrentIterableLinkedQueue.this.lock.readLock().unlock();
            }
        }
    }
}

