/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PathContainsFilter
extends SchemaFilter {
    private final String containString;

    public PathContainsFilter(String containString) {
        this.containString = containString.toLowerCase();
    }

    public PathContainsFilter(ByteBuffer byteBuffer) {
        this.containString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public String getContainString() {
        return this.containString;
    }

    @Override
    public <C> boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitPathContainsFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.PATH_CONTAINS;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.containString, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.containString, (OutputStream)stream);
    }
}

