/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class BrowsePathTarget
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=546");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=548");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=547");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15191");
    private final ExpandedNodeId targetId;
    private final UInteger remainingPathIndex;

    public BrowsePathTarget(ExpandedNodeId targetId, UInteger remainingPathIndex) {
        this.targetId = targetId;
        this.remainingPathIndex = remainingPathIndex;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public ExpandedNodeId getTargetId() {
        return this.targetId;
    }

    public UInteger getRemainingPathIndex() {
        return this.remainingPathIndex;
    }

    protected BrowsePathTarget(BrowsePathTargetBuilder<?, ?> b) {
        super(b);
        this.targetId = ((BrowsePathTargetBuilder)b).targetId;
        this.remainingPathIndex = ((BrowsePathTargetBuilder)b).remainingPathIndex;
    }

    public static BrowsePathTargetBuilder<?, ?> builder() {
        return new BrowsePathTargetBuilderImpl();
    }

    public BrowsePathTargetBuilder<?, ?> toBuilder() {
        return new BrowsePathTargetBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowsePathTarget)) {
            return false;
        }
        BrowsePathTarget other = (BrowsePathTarget)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExpandedNodeId this$targetId = this.getTargetId();
        ExpandedNodeId other$targetId = other.getTargetId();
        if (this$targetId == null ? other$targetId != null : !((Object)this$targetId).equals(other$targetId)) {
            return false;
        }
        UInteger this$remainingPathIndex = this.getRemainingPathIndex();
        UInteger other$remainingPathIndex = other.getRemainingPathIndex();
        return !(this$remainingPathIndex == null ? other$remainingPathIndex != null : !((Object)this$remainingPathIndex).equals(other$remainingPathIndex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowsePathTarget;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExpandedNodeId $targetId = this.getTargetId();
        result = result * 59 + ($targetId == null ? 43 : ((Object)$targetId).hashCode());
        UInteger $remainingPathIndex = this.getRemainingPathIndex();
        result = result * 59 + ($remainingPathIndex == null ? 43 : ((Object)$remainingPathIndex).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BrowsePathTarget(targetId=" + this.getTargetId() + ", remainingPathIndex=" + this.getRemainingPathIndex() + ")";
    }

    private static final class BrowsePathTargetBuilderImpl
    extends BrowsePathTargetBuilder<BrowsePathTarget, BrowsePathTargetBuilderImpl> {
        private BrowsePathTargetBuilderImpl() {
        }

        @Override
        protected BrowsePathTargetBuilderImpl self() {
            return this;
        }

        @Override
        public BrowsePathTarget build() {
            return new BrowsePathTarget(this);
        }
    }

    public static abstract class BrowsePathTargetBuilder<C extends BrowsePathTarget, B extends BrowsePathTargetBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ExpandedNodeId targetId;
        private UInteger remainingPathIndex;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrowsePathTargetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrowsePathTarget instance, BrowsePathTargetBuilder<?, ?> b) {
            b.targetId(instance.targetId);
            b.remainingPathIndex(instance.remainingPathIndex);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B targetId(ExpandedNodeId targetId) {
            this.targetId = targetId;
            return (B)this.self();
        }

        public B remainingPathIndex(UInteger remainingPathIndex) {
            this.remainingPathIndex = remainingPathIndex;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrowsePathTarget.BrowsePathTargetBuilder(super=" + super.toString() + ", targetId=" + this.targetId + ", remainingPathIndex=" + this.remainingPathIndex + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<BrowsePathTarget> {
        @Override
        public Class<BrowsePathTarget> getType() {
            return BrowsePathTarget.class;
        }

        @Override
        public BrowsePathTarget decode(SerializationContext context, UaDecoder decoder) {
            ExpandedNodeId targetId = decoder.readExpandedNodeId("TargetId");
            UInteger remainingPathIndex = decoder.readUInt32("RemainingPathIndex");
            return new BrowsePathTarget(targetId, remainingPathIndex);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowsePathTarget value) {
            encoder.writeExpandedNodeId("TargetId", value.getTargetId());
            encoder.writeUInt32("RemainingPathIndex", value.getRemainingPathIndex());
        }
    }
}

