/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class DeleteNodesItem
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=382");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=383");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=384");
    private final NodeId nodeId;
    private final Boolean deleteTargetReferences;

    public DeleteNodesItem(NodeId nodeId, Boolean deleteTargetReferences) {
        this.nodeId = nodeId;
        this.deleteTargetReferences = deleteTargetReferences;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Boolean getDeleteTargetReferences() {
        return this.deleteTargetReferences;
    }

    protected DeleteNodesItem(DeleteNodesItemBuilder<?, ?> b) {
        super(b);
        this.nodeId = ((DeleteNodesItemBuilder)b).nodeId;
        this.deleteTargetReferences = ((DeleteNodesItemBuilder)b).deleteTargetReferences;
    }

    public static DeleteNodesItemBuilder<?, ?> builder() {
        return new DeleteNodesItemBuilderImpl();
    }

    public DeleteNodesItemBuilder<?, ?> toBuilder() {
        return new DeleteNodesItemBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteNodesItem)) {
            return false;
        }
        DeleteNodesItem other = (DeleteNodesItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleteTargetReferences = this.getDeleteTargetReferences();
        Boolean other$deleteTargetReferences = other.getDeleteTargetReferences();
        if (this$deleteTargetReferences == null ? other$deleteTargetReferences != null : !((Object)this$deleteTargetReferences).equals(other$deleteTargetReferences)) {
            return false;
        }
        NodeId this$nodeId = this.getNodeId();
        NodeId other$nodeId = other.getNodeId();
        return !(this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteNodesItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleteTargetReferences = this.getDeleteTargetReferences();
        result = result * 59 + ($deleteTargetReferences == null ? 43 : ((Object)$deleteTargetReferences).hashCode());
        NodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteNodesItem(nodeId=" + this.getNodeId() + ", deleteTargetReferences=" + this.getDeleteTargetReferences() + ")";
    }

    private static final class DeleteNodesItemBuilderImpl
    extends DeleteNodesItemBuilder<DeleteNodesItem, DeleteNodesItemBuilderImpl> {
        private DeleteNodesItemBuilderImpl() {
        }

        @Override
        protected DeleteNodesItemBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteNodesItem build() {
            return new DeleteNodesItem(this);
        }
    }

    public static abstract class DeleteNodesItemBuilder<C extends DeleteNodesItem, B extends DeleteNodesItemBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId nodeId;
        private Boolean deleteTargetReferences;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteNodesItemBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DeleteNodesItem instance, DeleteNodesItemBuilder<?, ?> b) {
            b.nodeId(instance.nodeId);
            b.deleteTargetReferences(instance.deleteTargetReferences);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B nodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B deleteTargetReferences(Boolean deleteTargetReferences) {
            this.deleteTargetReferences = deleteTargetReferences;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DeleteNodesItem.DeleteNodesItemBuilder(super=" + super.toString() + ", nodeId=" + this.nodeId + ", deleteTargetReferences=" + this.deleteTargetReferences + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteNodesItem> {
        @Override
        public Class<DeleteNodesItem> getType() {
            return DeleteNodesItem.class;
        }

        @Override
        public DeleteNodesItem decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            Boolean deleteTargetReferences = decoder.readBoolean("DeleteTargetReferences");
            return new DeleteNodesItem(nodeId, deleteTargetReferences);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteNodesItem value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeBoolean("DeleteTargetReferences", value.getDeleteTargetReferences());
        }
    }
}

