/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ModifySubscriptionResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=794");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=796");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=795");
    private final ResponseHeader responseHeader;
    private final Double revisedPublishingInterval;
    private final UInteger revisedLifetimeCount;
    private final UInteger revisedMaxKeepAliveCount;

    public ModifySubscriptionResponse(ResponseHeader responseHeader, Double revisedPublishingInterval, UInteger revisedLifetimeCount, UInteger revisedMaxKeepAliveCount) {
        this.responseHeader = responseHeader;
        this.revisedPublishingInterval = revisedPublishingInterval;
        this.revisedLifetimeCount = revisedLifetimeCount;
        this.revisedMaxKeepAliveCount = revisedMaxKeepAliveCount;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public Double getRevisedPublishingInterval() {
        return this.revisedPublishingInterval;
    }

    public UInteger getRevisedLifetimeCount() {
        return this.revisedLifetimeCount;
    }

    public UInteger getRevisedMaxKeepAliveCount() {
        return this.revisedMaxKeepAliveCount;
    }

    protected ModifySubscriptionResponse(ModifySubscriptionResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((ModifySubscriptionResponseBuilder)b).responseHeader;
        this.revisedPublishingInterval = ((ModifySubscriptionResponseBuilder)b).revisedPublishingInterval;
        this.revisedLifetimeCount = ((ModifySubscriptionResponseBuilder)b).revisedLifetimeCount;
        this.revisedMaxKeepAliveCount = ((ModifySubscriptionResponseBuilder)b).revisedMaxKeepAliveCount;
    }

    public static ModifySubscriptionResponseBuilder<?, ?> builder() {
        return new ModifySubscriptionResponseBuilderImpl();
    }

    public ModifySubscriptionResponseBuilder<?, ?> toBuilder() {
        return new ModifySubscriptionResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifySubscriptionResponse)) {
            return false;
        }
        ModifySubscriptionResponse other = (ModifySubscriptionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$revisedPublishingInterval = this.getRevisedPublishingInterval();
        Double other$revisedPublishingInterval = other.getRevisedPublishingInterval();
        if (this$revisedPublishingInterval == null ? other$revisedPublishingInterval != null : !((Object)this$revisedPublishingInterval).equals(other$revisedPublishingInterval)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        UInteger this$revisedLifetimeCount = this.getRevisedLifetimeCount();
        UInteger other$revisedLifetimeCount = other.getRevisedLifetimeCount();
        if (this$revisedLifetimeCount == null ? other$revisedLifetimeCount != null : !((Object)this$revisedLifetimeCount).equals(other$revisedLifetimeCount)) {
            return false;
        }
        UInteger this$revisedMaxKeepAliveCount = this.getRevisedMaxKeepAliveCount();
        UInteger other$revisedMaxKeepAliveCount = other.getRevisedMaxKeepAliveCount();
        return !(this$revisedMaxKeepAliveCount == null ? other$revisedMaxKeepAliveCount != null : !((Object)this$revisedMaxKeepAliveCount).equals(other$revisedMaxKeepAliveCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifySubscriptionResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $revisedPublishingInterval = this.getRevisedPublishingInterval();
        result = result * 59 + ($revisedPublishingInterval == null ? 43 : ((Object)$revisedPublishingInterval).hashCode());
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        UInteger $revisedLifetimeCount = this.getRevisedLifetimeCount();
        result = result * 59 + ($revisedLifetimeCount == null ? 43 : ((Object)$revisedLifetimeCount).hashCode());
        UInteger $revisedMaxKeepAliveCount = this.getRevisedMaxKeepAliveCount();
        result = result * 59 + ($revisedMaxKeepAliveCount == null ? 43 : ((Object)$revisedMaxKeepAliveCount).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ModifySubscriptionResponse(responseHeader=" + this.getResponseHeader() + ", revisedPublishingInterval=" + this.getRevisedPublishingInterval() + ", revisedLifetimeCount=" + this.getRevisedLifetimeCount() + ", revisedMaxKeepAliveCount=" + this.getRevisedMaxKeepAliveCount() + ")";
    }

    private static final class ModifySubscriptionResponseBuilderImpl
    extends ModifySubscriptionResponseBuilder<ModifySubscriptionResponse, ModifySubscriptionResponseBuilderImpl> {
        private ModifySubscriptionResponseBuilderImpl() {
        }

        @Override
        protected ModifySubscriptionResponseBuilderImpl self() {
            return this;
        }

        @Override
        public ModifySubscriptionResponse build() {
            return new ModifySubscriptionResponse(this);
        }
    }

    public static abstract class ModifySubscriptionResponseBuilder<C extends ModifySubscriptionResponse, B extends ModifySubscriptionResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private Double revisedPublishingInterval;
        private UInteger revisedLifetimeCount;
        private UInteger revisedMaxKeepAliveCount;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModifySubscriptionResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ModifySubscriptionResponse instance, ModifySubscriptionResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.revisedPublishingInterval(instance.revisedPublishingInterval);
            b.revisedLifetimeCount(instance.revisedLifetimeCount);
            b.revisedMaxKeepAliveCount(instance.revisedMaxKeepAliveCount);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B revisedPublishingInterval(Double revisedPublishingInterval) {
            this.revisedPublishingInterval = revisedPublishingInterval;
            return (B)this.self();
        }

        public B revisedLifetimeCount(UInteger revisedLifetimeCount) {
            this.revisedLifetimeCount = revisedLifetimeCount;
            return (B)this.self();
        }

        public B revisedMaxKeepAliveCount(UInteger revisedMaxKeepAliveCount) {
            this.revisedMaxKeepAliveCount = revisedMaxKeepAliveCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ModifySubscriptionResponse.ModifySubscriptionResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", revisedPublishingInterval=" + this.revisedPublishingInterval + ", revisedLifetimeCount=" + this.revisedLifetimeCount + ", revisedMaxKeepAliveCount=" + this.revisedMaxKeepAliveCount + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ModifySubscriptionResponse> {
        @Override
        public Class<ModifySubscriptionResponse> getType() {
            return ModifySubscriptionResponse.class;
        }

        @Override
        public ModifySubscriptionResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            Double revisedPublishingInterval = decoder.readDouble("RevisedPublishingInterval");
            UInteger revisedLifetimeCount = decoder.readUInt32("RevisedLifetimeCount");
            UInteger revisedMaxKeepAliveCount = decoder.readUInt32("RevisedMaxKeepAliveCount");
            return new ModifySubscriptionResponse(responseHeader, revisedPublishingInterval, revisedLifetimeCount, revisedMaxKeepAliveCount);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ModifySubscriptionResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeDouble("RevisedPublishingInterval", value.getRevisedPublishingInterval());
            encoder.writeUInt32("RevisedLifetimeCount", value.getRevisedLifetimeCount());
            encoder.writeUInt32("RevisedMaxKeepAliveCount", value.getRevisedMaxKeepAliveCount());
        }
    }
}

