/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class MonitoredItemCreateResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=746");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=748");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=747");
    private final StatusCode statusCode;
    private final UInteger monitoredItemId;
    private final Double revisedSamplingInterval;
    private final UInteger revisedQueueSize;
    private final ExtensionObject filterResult;

    public MonitoredItemCreateResult(StatusCode statusCode, UInteger monitoredItemId, Double revisedSamplingInterval, UInteger revisedQueueSize, ExtensionObject filterResult) {
        this.statusCode = statusCode;
        this.monitoredItemId = monitoredItemId;
        this.revisedSamplingInterval = revisedSamplingInterval;
        this.revisedQueueSize = revisedQueueSize;
        this.filterResult = filterResult;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public UInteger getMonitoredItemId() {
        return this.monitoredItemId;
    }

    public Double getRevisedSamplingInterval() {
        return this.revisedSamplingInterval;
    }

    public UInteger getRevisedQueueSize() {
        return this.revisedQueueSize;
    }

    public ExtensionObject getFilterResult() {
        return this.filterResult;
    }

    protected MonitoredItemCreateResult(MonitoredItemCreateResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((MonitoredItemCreateResultBuilder)b).statusCode;
        this.monitoredItemId = ((MonitoredItemCreateResultBuilder)b).monitoredItemId;
        this.revisedSamplingInterval = ((MonitoredItemCreateResultBuilder)b).revisedSamplingInterval;
        this.revisedQueueSize = ((MonitoredItemCreateResultBuilder)b).revisedQueueSize;
        this.filterResult = ((MonitoredItemCreateResultBuilder)b).filterResult;
    }

    public static MonitoredItemCreateResultBuilder<?, ?> builder() {
        return new MonitoredItemCreateResultBuilderImpl();
    }

    public MonitoredItemCreateResultBuilder<?, ?> toBuilder() {
        return new MonitoredItemCreateResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoredItemCreateResult)) {
            return false;
        }
        MonitoredItemCreateResult other = (MonitoredItemCreateResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$revisedSamplingInterval = this.getRevisedSamplingInterval();
        Double other$revisedSamplingInterval = other.getRevisedSamplingInterval();
        if (this$revisedSamplingInterval == null ? other$revisedSamplingInterval != null : !((Object)this$revisedSamplingInterval).equals(other$revisedSamplingInterval)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        UInteger this$monitoredItemId = this.getMonitoredItemId();
        UInteger other$monitoredItemId = other.getMonitoredItemId();
        if (this$monitoredItemId == null ? other$monitoredItemId != null : !((Object)this$monitoredItemId).equals(other$monitoredItemId)) {
            return false;
        }
        UInteger this$revisedQueueSize = this.getRevisedQueueSize();
        UInteger other$revisedQueueSize = other.getRevisedQueueSize();
        if (this$revisedQueueSize == null ? other$revisedQueueSize != null : !((Object)this$revisedQueueSize).equals(other$revisedQueueSize)) {
            return false;
        }
        ExtensionObject this$filterResult = this.getFilterResult();
        ExtensionObject other$filterResult = other.getFilterResult();
        return !(this$filterResult == null ? other$filterResult != null : !((Object)this$filterResult).equals(other$filterResult));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitoredItemCreateResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $revisedSamplingInterval = this.getRevisedSamplingInterval();
        result = result * 59 + ($revisedSamplingInterval == null ? 43 : ((Object)$revisedSamplingInterval).hashCode());
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        UInteger $monitoredItemId = this.getMonitoredItemId();
        result = result * 59 + ($monitoredItemId == null ? 43 : ((Object)$monitoredItemId).hashCode());
        UInteger $revisedQueueSize = this.getRevisedQueueSize();
        result = result * 59 + ($revisedQueueSize == null ? 43 : ((Object)$revisedQueueSize).hashCode());
        ExtensionObject $filterResult = this.getFilterResult();
        result = result * 59 + ($filterResult == null ? 43 : ((Object)$filterResult).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MonitoredItemCreateResult(statusCode=" + this.getStatusCode() + ", monitoredItemId=" + this.getMonitoredItemId() + ", revisedSamplingInterval=" + this.getRevisedSamplingInterval() + ", revisedQueueSize=" + this.getRevisedQueueSize() + ", filterResult=" + this.getFilterResult() + ")";
    }

    private static final class MonitoredItemCreateResultBuilderImpl
    extends MonitoredItemCreateResultBuilder<MonitoredItemCreateResult, MonitoredItemCreateResultBuilderImpl> {
        private MonitoredItemCreateResultBuilderImpl() {
        }

        @Override
        protected MonitoredItemCreateResultBuilderImpl self() {
            return this;
        }

        @Override
        public MonitoredItemCreateResult build() {
            return new MonitoredItemCreateResult(this);
        }
    }

    public static abstract class MonitoredItemCreateResultBuilder<C extends MonitoredItemCreateResult, B extends MonitoredItemCreateResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private UInteger monitoredItemId;
        private Double revisedSamplingInterval;
        private UInteger revisedQueueSize;
        private ExtensionObject filterResult;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MonitoredItemCreateResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(MonitoredItemCreateResult instance, MonitoredItemCreateResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.monitoredItemId(instance.monitoredItemId);
            b.revisedSamplingInterval(instance.revisedSamplingInterval);
            b.revisedQueueSize(instance.revisedQueueSize);
            b.filterResult(instance.filterResult);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B monitoredItemId(UInteger monitoredItemId) {
            this.monitoredItemId = monitoredItemId;
            return (B)this.self();
        }

        public B revisedSamplingInterval(Double revisedSamplingInterval) {
            this.revisedSamplingInterval = revisedSamplingInterval;
            return (B)this.self();
        }

        public B revisedQueueSize(UInteger revisedQueueSize) {
            this.revisedQueueSize = revisedQueueSize;
            return (B)this.self();
        }

        public B filterResult(ExtensionObject filterResult) {
            this.filterResult = filterResult;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MonitoredItemCreateResult.MonitoredItemCreateResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", monitoredItemId=" + this.monitoredItemId + ", revisedSamplingInterval=" + this.revisedSamplingInterval + ", revisedQueueSize=" + this.revisedQueueSize + ", filterResult=" + this.filterResult + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<MonitoredItemCreateResult> {
        @Override
        public Class<MonitoredItemCreateResult> getType() {
            return MonitoredItemCreateResult.class;
        }

        @Override
        public MonitoredItemCreateResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            UInteger monitoredItemId = decoder.readUInt32("MonitoredItemId");
            Double revisedSamplingInterval = decoder.readDouble("RevisedSamplingInterval");
            UInteger revisedQueueSize = decoder.readUInt32("RevisedQueueSize");
            ExtensionObject filterResult = decoder.readExtensionObject("FilterResult");
            return new MonitoredItemCreateResult(statusCode, monitoredItemId, revisedSamplingInterval, revisedQueueSize, filterResult);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MonitoredItemCreateResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeUInt32("MonitoredItemId", value.getMonitoredItemId());
            encoder.writeDouble("RevisedSamplingInterval", value.getRevisedSamplingInterval());
            encoder.writeUInt32("RevisedQueueSize", value.getRevisedQueueSize());
            encoder.writeExtensionObject("FilterResult", value.getFilterResult());
        }
    }
}

