/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import org.apache.tsfile.encoding.encoder.GorillaEncoderV2;

public class LongGorillaEncoder
extends GorillaEncoderV2 {
    private static final int ONE_ITEM_MAX_SIZE = 10;
    private long storedValue = 0L;

    @Override
    public final int getOneItemMaxSize() {
        return 10;
    }

    @Override
    public final void encode(long value, ByteArrayOutputStream out) {
        if (this.firstValueWasWritten) {
            this.compressValue(value, out);
        } else {
            this.writeFirst(value, out);
            this.firstValueWasWritten = true;
        }
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        this.encode(Long.MIN_VALUE, out);
        this.bitsLeft = 0;
        this.flipByte(out);
        this.reset();
    }

    @Override
    protected void reset() {
        super.reset();
        this.storedValue = 0L;
    }

    private void writeFirst(long value, ByteArrayOutputStream out) {
        this.storedValue = value;
        this.writeBits(value, 64, out);
    }

    private void compressValue(long value, ByteArrayOutputStream out) {
        long xor = this.storedValue ^ value;
        this.storedValue = value;
        if (xor == 0L) {
            this.skipBit(out);
        } else {
            this.writeBit(out);
            int leadingZeros = Long.numberOfLeadingZeros(xor);
            int trailingZeros = Long.numberOfTrailingZeros(xor);
            if (leadingZeros >= this.storedLeadingZeros && trailingZeros >= this.storedTrailingZeros) {
                this.writeExistingLeading(xor, out);
            } else {
                this.writeNewLeading(xor, leadingZeros, trailingZeros, out);
            }
        }
    }

    private void writeExistingLeading(long xor, ByteArrayOutputStream out) {
        this.skipBit(out);
        int significantBits = 64 - this.storedLeadingZeros - this.storedTrailingZeros;
        this.writeBits(xor >>> this.storedTrailingZeros, significantBits, out);
    }

    private void writeNewLeading(long xor, int leadingZeros, int trailingZeros, ByteArrayOutputStream out) {
        this.writeBit(out);
        int significantBits = 64 - leadingZeros - trailingZeros;
        this.writeBits(leadingZeros, 6, out);
        this.writeBits((long)significantBits - 1L, 6, out);
        this.writeBits(xor >>> trailingZeros, significantBits, out);
        this.storedLeadingZeros = leadingZeros;
        this.storedTrailingZeros = trailingZeros;
    }
}

