/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ParsingResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=610");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=612");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=611");
    private final StatusCode statusCode;
    private final StatusCode[] dataStatusCodes;
    private final DiagnosticInfo[] dataDiagnosticInfos;

    public ParsingResult(StatusCode statusCode, StatusCode[] dataStatusCodes, DiagnosticInfo[] dataDiagnosticInfos) {
        this.statusCode = statusCode;
        this.dataStatusCodes = dataStatusCodes;
        this.dataDiagnosticInfos = dataDiagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public StatusCode[] getDataStatusCodes() {
        return this.dataStatusCodes;
    }

    public DiagnosticInfo[] getDataDiagnosticInfos() {
        return this.dataDiagnosticInfos;
    }

    protected ParsingResult(ParsingResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((ParsingResultBuilder)b).statusCode;
        this.dataStatusCodes = ((ParsingResultBuilder)b).dataStatusCodes;
        this.dataDiagnosticInfos = ((ParsingResultBuilder)b).dataDiagnosticInfos;
    }

    public static ParsingResultBuilder<?, ?> builder() {
        return new ParsingResultBuilderImpl();
    }

    public ParsingResultBuilder<?, ?> toBuilder() {
        return new ParsingResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParsingResult)) {
            return false;
        }
        ParsingResult other = (ParsingResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDataStatusCodes(), other.getDataStatusCodes())) {
            return false;
        }
        return Arrays.deepEquals(this.getDataDiagnosticInfos(), other.getDataDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParsingResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDataStatusCodes());
        result = result * 59 + Arrays.deepHashCode(this.getDataDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "ParsingResult(statusCode=" + this.getStatusCode() + ", dataStatusCodes=" + Arrays.deepToString(this.getDataStatusCodes()) + ", dataDiagnosticInfos=" + Arrays.deepToString(this.getDataDiagnosticInfos()) + ")";
    }

    private static final class ParsingResultBuilderImpl
    extends ParsingResultBuilder<ParsingResult, ParsingResultBuilderImpl> {
        private ParsingResultBuilderImpl() {
        }

        @Override
        protected ParsingResultBuilderImpl self() {
            return this;
        }

        @Override
        public ParsingResult build() {
            return new ParsingResult(this);
        }
    }

    public static abstract class ParsingResultBuilder<C extends ParsingResult, B extends ParsingResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private StatusCode[] dataStatusCodes;
        private DiagnosticInfo[] dataDiagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ParsingResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ParsingResult instance, ParsingResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.dataStatusCodes(instance.dataStatusCodes);
            b.dataDiagnosticInfos(instance.dataDiagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B dataStatusCodes(StatusCode[] dataStatusCodes) {
            this.dataStatusCodes = dataStatusCodes;
            return (B)this.self();
        }

        public B dataDiagnosticInfos(DiagnosticInfo[] dataDiagnosticInfos) {
            this.dataDiagnosticInfos = dataDiagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ParsingResult.ParsingResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", dataStatusCodes=" + Arrays.deepToString(this.dataStatusCodes) + ", dataDiagnosticInfos=" + Arrays.deepToString(this.dataDiagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ParsingResult> {
        @Override
        public Class<ParsingResult> getType() {
            return ParsingResult.class;
        }

        @Override
        public ParsingResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            StatusCode[] dataStatusCodes = decoder.readStatusCodeArray("DataStatusCodes");
            DiagnosticInfo[] dataDiagnosticInfos = decoder.readDiagnosticInfoArray("DataDiagnosticInfos");
            return new ParsingResult(statusCode, dataStatusCodes, dataDiagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ParsingResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeStatusCodeArray("DataStatusCodes", value.getDataStatusCodes());
            encoder.writeDiagnosticInfoArray("DataDiagnosticInfos", value.getDataDiagnosticInfos());
        }
    }
}

