/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.util.Preconditions;

public final class LogSegmentStartEnd
implements Comparable<LogSegmentStartEnd> {
    private static final String LOG_FILE_NAME_PREFIX = "log";
    private static final String IN_PROGRESS = "inprogress";
    private static final Pattern CLOSED_SEGMENT_PATTERN;
    private static final Pattern OPEN_SEGMENT_PATTERN;
    private final long startIndex;
    private final Long endIndex;

    private static String getOpenLogFileName(long startIndex) {
        return "log_inprogress_" + startIndex;
    }

    static Pattern getOpenSegmentPattern() {
        return OPEN_SEGMENT_PATTERN;
    }

    private static String getClosedLogFileName(long startIndex, long endIndex) {
        return "log_" + startIndex + "-" + endIndex;
    }

    static Pattern getClosedSegmentPattern() {
        return CLOSED_SEGMENT_PATTERN;
    }

    static LogSegmentStartEnd valueOf(long startIndex) {
        return new LogSegmentStartEnd(startIndex, null);
    }

    static LogSegmentStartEnd valueOf(long startIndex, Long endIndex) {
        return new LogSegmentStartEnd(startIndex, endIndex);
    }

    static LogSegmentStartEnd valueOf(long startIndex, long endIndex, boolean isOpen) {
        return new LogSegmentStartEnd(startIndex, isOpen ? null : Long.valueOf(endIndex));
    }

    private LogSegmentStartEnd(long startIndex, Long endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        Preconditions.assertTrue((startIndex >= 0L ? 1 : 0) != 0, (Object)this);
        if (endIndex != null) {
            Preconditions.assertTrue((endIndex >= startIndex ? 1 : 0) != 0, (Object)this);
        }
    }

    long getStartIndex() {
        return this.startIndex;
    }

    long getEndIndex() {
        return Objects.requireNonNull(this.endIndex, "endIndex");
    }

    boolean isOpen() {
        return this.endIndex == null;
    }

    private String getFileName() {
        return this.isOpen() ? LogSegmentStartEnd.getOpenLogFileName(this.startIndex) : LogSegmentStartEnd.getClosedLogFileName(this.startIndex, this.endIndex);
    }

    File getFile(File dir) {
        return new File(dir, this.getFileName());
    }

    File getFile(RaftStorage storage) {
        return this.getFile(storage.getStorageDir().getCurrentDir());
    }

    @Override
    public int compareTo(LogSegmentStartEnd that) {
        if (this == that) {
            return 0;
        }
        int diff = Long.compare(this.getStartIndex(), that.getStartIndex());
        if (diff != 0) {
            return diff;
        }
        if (this.isOpen()) {
            return that.isOpen() ? 0 : -1;
        }
        return that.isOpen() ? 1 : Long.compare(this.endIndex, that.endIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LogSegmentStartEnd that = (LogSegmentStartEnd)obj;
        return this.startIndex == that.startIndex && Objects.equals(this.endIndex, that.endIndex);
    }

    public int hashCode() {
        return Objects.hash(this.startIndex, this.endIndex);
    }

    public String toString() {
        return this.startIndex + "-" + (this.endIndex != null ? this.endIndex : "");
    }

    static {
        String digits = "(\\d+)";
        CLOSED_SEGMENT_PATTERN = Pattern.compile("log_(\\d+)-(\\d+)");
        OPEN_SEGMENT_PATTERN = Pattern.compile("log_inprogress_(\\d+)(?:\\..*)?");
    }
}

