/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.ValueRank;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.SessionListener;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.SessionSecurityDiagnosticsVariable;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.Util;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.SessionSecurityDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.SessionSecurityDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeFactory;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.SessionSecurityDiagnosticsDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSecurityDiagnosticsVariableArray
extends AbstractLifecycle {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean diagnosticsEnabled = new AtomicBoolean(false);
    private final List<SessionSecurityDiagnosticsVariable> sessionSecurityDiagnosticsVariables = Collections.synchronizedList(new ArrayList());
    private AttributeObserver attributeObserver;
    private SessionListener sessionListener;
    private final OpcUaServer server;
    private final NodeFactory nodeFactory;
    private final SessionSecurityDiagnosticsArrayTypeNode node;
    private final NodeManager<UaNode> diagnosticsNodeManager;

    public SessionSecurityDiagnosticsVariableArray(SessionSecurityDiagnosticsArrayTypeNode node, final NodeManager<UaNode> diagnosticsNodeManager) {
        this.node = node;
        this.diagnosticsNodeManager = diagnosticsNodeManager;
        this.server = node.getNodeContext().getServer();
        this.nodeFactory = new NodeFactory(new UaNodeContext(){

            @Override
            public OpcUaServer getServer() {
                return SessionSecurityDiagnosticsVariableArray.this.server;
            }

            @Override
            public NodeManager<UaNode> getNodeManager() {
                return diagnosticsNodeManager;
            }
        });
    }

    @Override
    protected void onStartup() {
        ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(Identifiers.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + Identifiers.Server_ServerDiagnostics));
        this.diagnosticsEnabled.set(diagnosticsNode.getEnabledFlag());
        if (this.diagnosticsEnabled.get()) {
            this.addSessionListener();
        }
        this.attributeObserver = (node, attributeId, value) -> {
            DataValue dataValue;
            Object o;
            if (attributeId == AttributeId.Value && (o = (dataValue = (DataValue)value).getValue().getValue()) instanceof Boolean) {
                boolean current = (Boolean)o;
                boolean previous = this.diagnosticsEnabled.getAndSet(current);
                if (!previous && current) {
                    this.server.getSessionManager().getAllSessions().forEach(this::createSessionSecurityDiagnosticsVariable);
                    if (this.sessionListener == null) {
                        this.addSessionListener();
                    }
                } else if (previous && !current) {
                    if (this.sessionListener != null) {
                        this.server.getSessionManager().removeSessionListener(this.sessionListener);
                        this.sessionListener = null;
                    }
                    this.sessionSecurityDiagnosticsVariables.forEach(Lifecycle::shutdown);
                    this.sessionSecurityDiagnosticsVariables.clear();
                }
            }
        };
        diagnosticsNode.getEnabledFlagNode().addAttributeObserver(this.attributeObserver);
        this.node.getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject[] xos = ExtensionObject.encodeArray((SerializationContext)this.server.getSerializationContext(), (UaStructure[])((UaStructure[])this.server.getSessionManager().getAllSessions().stream().map(s -> s.getSessionSecurityDiagnostics().getSessionSecurityDiagnosticsDataType()).toArray(SessionSecurityDiagnosticsDataType[]::new)));
            return new DataValue(new Variant((Object)xos));
        }));
    }

    private void addSessionListener() {
        this.sessionListener = new SessionListener(){

            @Override
            public void onSessionCreated(Session session) {
                SessionSecurityDiagnosticsVariableArray.this.createSessionSecurityDiagnosticsVariable(session);
            }

            @Override
            public void onSessionClosed(Session session) {
                for (int i = 0; i < SessionSecurityDiagnosticsVariableArray.this.sessionSecurityDiagnosticsVariables.size(); ++i) {
                    SessionSecurityDiagnosticsVariable v = (SessionSecurityDiagnosticsVariable)SessionSecurityDiagnosticsVariableArray.this.sessionSecurityDiagnosticsVariables.get(i);
                    if (!v.getSession().getSessionId().equals((Object)session.getSessionId())) continue;
                    SessionSecurityDiagnosticsVariableArray.this.sessionSecurityDiagnosticsVariables.remove(i);
                    v.shutdown();
                    break;
                }
            }
        };
        this.server.getSessionManager().addSessionListener(this.sessionListener);
    }

    private void createSessionSecurityDiagnosticsVariable(Session session) {
        try {
            int index = this.sessionSecurityDiagnosticsVariables.size();
            String id = Util.buildBrowseNamePath(this.node) + "[" + index + "]";
            NodeId elementNodeId = new NodeId(1, id);
            SessionSecurityDiagnosticsTypeNode elementNode = (SessionSecurityDiagnosticsTypeNode)this.nodeFactory.createNode(elementNodeId, Identifiers.SessionSecurityDiagnosticsType);
            elementNode.setBrowseName(new QualifiedName(1, "SessionSecurityDiagnostics"));
            elementNode.setDisplayName(new LocalizedText(this.node.getDisplayName().getLocale(), "SessionSecurityDiagnostics"));
            elementNode.setArrayDimensions(null);
            elementNode.setValueRank(ValueRank.Scalar.getValue());
            elementNode.setDataType(Identifiers.SessionSecurityDiagnosticsDataType);
            elementNode.setAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_ONLY));
            elementNode.setUserAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_ONLY));
            elementNode.addReference(new Reference(elementNode.getNodeId(), Identifiers.HasComponent, this.node.getNodeId().expanded(), Reference.Direction.INVERSE));
            this.diagnosticsNodeManager.addNode(elementNode);
            SessionSecurityDiagnosticsVariable sessionSecurityDiagnosticsVariable = new SessionSecurityDiagnosticsVariable(elementNode, session);
            sessionSecurityDiagnosticsVariable.startup();
            this.sessionSecurityDiagnosticsVariables.add(sessionSecurityDiagnosticsVariable);
        }
        catch (UaException e) {
            this.logger.warn("Failed to create SessionDiagnosticsVariableTypeNode for session id={}", (Object)session.getSessionId(), (Object)e);
        }
    }

    @Override
    protected void onShutdown() {
        AttributeObserver observer = this.attributeObserver;
        if (observer != null) {
            ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(Identifiers.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + Identifiers.Server_ServerDiagnostics));
            diagnosticsNode.getEnabledFlagNode().removeAttributeObserver(observer);
            this.attributeObserver = null;
        }
        if (this.sessionListener != null) {
            this.server.getSessionManager().removeSessionListener(this.sessionListener);
            this.sessionListener = null;
        }
        this.sessionSecurityDiagnosticsVariables.forEach(Lifecycle::shutdown);
        this.sessionSecurityDiagnosticsVariables.clear();
        this.node.delete();
    }
}

