/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.AbstractCli;
import org.apache.iotdb.cli.type.ExitType;
import org.apache.iotdb.cli.utils.CliContext;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.thrift.TException;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.UserInterruptException;

public class Cli
extends AbstractCli {
    private static CommandLine commandLine;
    private static final Properties info;

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        Cli.runCli(new CliContext(System.in, System.out, System.err, ExitType.SYSTEM_EXIT), args);
    }

    public static void runCli(CliContext ctx, String[] args) throws ClassNotFoundException, IOException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Options options = Cli.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(88);
        commandLine = null;
        if (args == null || args.length == 0) {
            ctx.getPrinter().println("Require more params input, eg. ./start-cli.sh(start-cli.bat if Windows) -h xxx.xxx.xxx.xxx -p xxxx -u xxx.");
            ctx.getPrinter().println("For more information, please check the following hint.");
            hf.printHelp("./start-cli.sh(start-cli.bat if Windows)", options, true);
            ctx.exit(1);
        }
        Cli.init();
        String[] newArgs = Cli.removePasswordArgs(args);
        String[] newArgs2 = Cli.processExecuteArgs(newArgs);
        boolean continues = Cli.parseCommandLine(ctx, options, newArgs2, hf);
        if (!continues) {
            ctx.exit(1);
        }
        try {
            host = Cli.checkRequiredArg(ctx, "h", "host", commandLine, false, host);
            port = Cli.checkRequiredArg(ctx, "p", "port", commandLine, false, port);
            username = Cli.checkRequiredArg(ctx, "u", "username", commandLine, true, null);
        }
        catch (ArgsErrorException e) {
            ctx.getPrinter().println("ErrorInput params error because" + e.getMessage());
            ctx.exit(1);
        }
        catch (Exception e) {
            ctx.getPrinter().println("ErrorExit cli with error " + e.getMessage());
            ctx.exit(1);
        }
        LineReader lineReader = JlineUtils.getLineReader(ctx, username, host, port);
        if (ctx.isDisableCliHistory()) {
            lineReader.getVariables().put("disable-history", Boolean.TRUE);
        }
        ctx.setLineReader(lineReader);
        Cli.serve(ctx);
    }

    private static void constructProperties() {
        if (Boolean.parseBoolean(useSsl)) {
            info.setProperty("use_ssl", useSsl);
            info.setProperty("trust_store", trustStore);
            info.setProperty("trust_store_pwd", trustStorePwd);
        }
        info.setProperty("user", username);
        info.setProperty("password", password);
        info.setProperty("sql_dialect", sqlDialect);
    }

    private static boolean parseCommandLine(CliContext ctx, Options options, String[] newArgs, HelpFormatter hf) {
        try {
            DefaultParser parser = new DefaultParser();
            commandLine = parser.parse(options, newArgs);
            if (commandLine.hasOption("help")) {
                hf.printHelp("./start-cli.sh(start-cli.bat if Windows)", options, true);
                return false;
            }
            if (commandLine.hasOption("c")) {
                Config.rpcThriftCompressionEnable = true;
            }
            if (commandLine.hasOption("disableISO8601")) {
                timeFormat = RpcUtils.setTimeFormat((String)"long");
            }
            if (commandLine.hasOption("timeout")) {
                Cli.setQueryTimeout(commandLine.getOptionValue("timeout"));
            }
            if (commandLine.hasOption("sql_dialect")) {
                Cli.setSqlDialect(commandLine.getOptionValue("sql_dialect"));
            }
        }
        catch (ParseException e) {
            ctx.getPrinter().println("Require more params input, eg. ./start-cli.sh(start-cli.bat if Windows) -h xxx.xxx.xxx.xxx -p xxxx -u xxx.");
            ctx.getPrinter().println("For more information, please check the following hint.");
            hf.printHelp("IoTDB", options, true);
            return false;
        }
        catch (NumberFormatException e) {
            ctx.getPrinter().println("Error: error format of max print row count, it should be an integer number");
            return false;
        }
        return true;
    }

    private static void serve(CliContext ctx) {
        try {
            useSsl = commandLine.getOptionValue("usessl");
            trustStore = commandLine.getOptionValue("ts");
            trustStorePwd = commandLine.getOptionValue("tpw");
            password = commandLine.getOptionValue("pw");
            Cli.constructProperties();
            if (hasExecuteSQL && password != null) {
                ctx.getLineReader().getVariables().put("disable-history", Boolean.TRUE);
                Cli.executeSql(ctx);
            }
            if (password == null) {
                password = ctx.getLineReader().readLine("please input your password:", Character.valueOf('\u0000'));
            }
            Cli.receiveCommands(ctx);
        }
        catch (Exception e) {
            ctx.getPrinter().println("Error: Exit cli with error: " + e.getMessage());
            ctx.exit(1);
        }
    }

    private static void executeSql(CliContext ctx) throws TException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + host + ":" + port + "/", info);){
            connection.setQueryTimeout(queryTimeout);
            properties = connection.getServerProperties();
            timestampPrecision = properties.getTimestampPrecision();
            AGGREGRATE_TIME_LIST.addAll(properties.getSupportedTimeAggregationOperations());
            Cli.processCommand(ctx, execute, connection);
            ctx.exit(lastProcessStatus);
        }
        catch (SQLException e) {
            ctx.getPrinter().println("ErrorCan't execute sql because" + e.getMessage());
            ctx.exit(1);
        }
    }

    private static void receiveCommands(CliContext ctx) throws TException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + host + ":" + port + "/", info);){
            boolean readLine;
            connection.setQueryTimeout(queryTimeout);
            properties = connection.getServerProperties();
            AGGREGRATE_TIME_LIST.addAll(properties.getSupportedTimeAggregationOperations());
            timestampPrecision = properties.getTimestampPrecision();
            Cli.echoStarting(ctx);
            Cli.displayLogo(ctx, properties.getLogo(), properties.getVersion(), properties.getBuildInfo());
            ctx.getPrinter().println(String.format("Successfully login at %s:%s", host, port));
            while (!(readLine = Cli.readerReadLine(ctx, connection))) {
            }
        }
        catch (SQLException e) {
            ctx.getErr().printf("%s: %s%n", "Error", e.getMessage());
            ctx.exit(1);
        }
    }

    private static boolean readerReadLine(CliContext ctx, IoTDBConnection connection) {
        try {
            String s = ctx.getLineReader().readLine(cliPrefix + "> ", null);
            boolean continues = Cli.processCommand(ctx, s, connection);
            if (!continues) {
                return true;
            }
        }
        catch (UserInterruptException e) {
            Cli.readLine(ctx);
        }
        catch (EndOfFileException e) {
            ctx.exit(0);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("history")) {
                return false;
            }
            throw e;
        }
        return false;
    }

    private static void readLine(CliContext ctx) {
        try {
            ctx.getLineReader().readLine("Press CTRL+C again to exit, or press ENTER to continue", Character.valueOf('\u0000'));
        }
        catch (EndOfFileException | UserInterruptException e2) {
            ctx.exit(0);
        }
    }

    static {
        info = new Properties();
    }
}

