/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.payload.thrift.common;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferSliceReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferSliceReqHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferSliceReqHandler.class);
    private int orderId = -1;
    private short originReqType = (short)-1;
    private int originBodySize = -1;
    private int sliceCount = -1;
    private final List<byte[]> sliceBodies = new ArrayList<byte[]>();

    public boolean receiveSlice(PipeTransferSliceReq req) {
        if (this.orderId == -1 || this.originReqType == -1 || this.originBodySize == -1 || this.sliceCount == -1 || this.sliceBodies.isEmpty()) {
            if (this.orderId == -1 && this.originReqType == -1 && this.originBodySize == -1 && this.sliceCount == -1 && this.sliceBodies.isEmpty()) {
                this.orderId = req.getOrderId();
                this.originReqType = req.getOriginReqType();
                this.originBodySize = req.getOriginBodySize();
                this.sliceCount = req.getSliceCount();
            } else {
                LOGGER.warn("Invalid state: orderId={}, originReqType={}, originBodySize={}, sliceCount={}, sliceBodies.size={}", new Object[]{this.orderId, this.originReqType, this.originBodySize, this.sliceCount, this.sliceBodies.size()});
                this.clear();
                return false;
            }
        }
        if (this.orderId != req.getOrderId()) {
            LOGGER.warn("Order ID mismatch: expected {}, actual {}", (Object)this.orderId, (Object)req.getOrderId());
            this.clear();
            return false;
        }
        if (this.originReqType != req.getOriginReqType()) {
            LOGGER.warn("Origin request type mismatch: expected {}, actual {}", (Object)this.originReqType, (Object)req.getOriginReqType());
            this.clear();
            return false;
        }
        if (this.originBodySize != req.getOriginBodySize()) {
            LOGGER.warn("Origin body size mismatch: expected {}, actual {}", (Object)this.originBodySize, (Object)req.getOriginBodySize());
            this.clear();
            return false;
        }
        if (this.sliceCount != req.getSliceCount()) {
            LOGGER.warn("Slice count mismatch: expected {}, actual {}", (Object)this.sliceCount, (Object)req.getSliceCount());
            this.clear();
            return false;
        }
        if (this.sliceBodies.size() != req.getSliceIndex()) {
            LOGGER.warn("Invalid slice index: expected {}, actual {}", (Object)this.sliceBodies.size(), (Object)req.getSliceIndex());
            this.clear();
            return false;
        }
        this.sliceBodies.add(req.getSliceBody());
        return true;
    }

    public Optional<TPipeTransferReq> makeReqIfComplete() {
        if (this.sliceBodies.size() != this.sliceCount) {
            return Optional.empty();
        }
        TPipeTransferReq req = new TPipeTransferReq();
        req.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        req.type = this.originReqType;
        ByteBuffer body = ByteBuffer.allocate(this.originBodySize);
        this.sliceBodies.forEach(body::put);
        body.flip();
        req.body = body;
        return Optional.of(req);
    }

    public void clear() {
        this.orderId = -1;
        this.originReqType = (short)-1;
        this.originBodySize = -1;
        this.sliceCount = -1;
        this.sliceBodies.clear();
    }
}

