/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.service.UDFClassLoader;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class UDFTable {
    private final Map<Model, Map<String, UDFInformation>> udfInformationMap = new ConcurrentHashMap<Model, Map<String, UDFInformation>>();
    private final Map<Model, Map<String, Class<?>>> functionToClassMap = new ConcurrentHashMap();

    public UDFTable() {
        this.udfInformationMap.put(Model.TREE, new ConcurrentHashMap());
        this.udfInformationMap.put(Model.TABLE, new ConcurrentHashMap());
        this.functionToClassMap.put(Model.TREE, new ConcurrentHashMap());
        this.functionToClassMap.put(Model.TABLE, new ConcurrentHashMap());
    }

    public void addUDFInformation(String functionName, UDFInformation udfInformation) {
        if (udfInformation.getUdfType().isTreeModel()) {
            this.udfInformationMap.get(Model.TREE).put(functionName.toUpperCase(), udfInformation);
        } else {
            this.udfInformationMap.get(Model.TABLE).put(functionName.toUpperCase(), udfInformation);
        }
    }

    public void removeUDFInformation(Model model, String functionName) {
        this.udfInformationMap.get(model).remove(functionName.toUpperCase());
    }

    public UDFInformation getUDFInformation(Model model, String functionName) {
        return this.udfInformationMap.get(model).get(functionName.toUpperCase());
    }

    public void addFunctionAndClass(Model model, String functionName, Class<?> clazz) {
        this.functionToClassMap.get(model).put(functionName.toUpperCase(), clazz);
    }

    public Class<?> getFunctionClass(Model model, String functionName) {
        return this.functionToClassMap.get(model).get(functionName.toUpperCase());
    }

    public void removeFunctionClass(Model model, String functionName) {
        this.functionToClassMap.get(model).remove(functionName.toUpperCase());
    }

    public void updateFunctionClass(UDFInformation udfInformation, UDFClassLoader classLoader) throws ClassNotFoundException {
        Class<?> functionClass = Class.forName(udfInformation.getClassName(), true, classLoader);
        if (udfInformation.getUdfType().isTreeModel()) {
            this.functionToClassMap.get(Model.TREE).put(udfInformation.getFunctionName().toUpperCase(), functionClass);
        } else {
            this.functionToClassMap.get(Model.TABLE).put(udfInformation.getFunctionName().toUpperCase(), functionClass);
        }
    }

    public List<UDFInformation> getUDFInformationList(Model model) {
        return new ArrayList<UDFInformation>(this.udfInformationMap.get(model).values());
    }

    public List<UDFInformation> getAllInformationList() {
        return this.udfInformationMap.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }

    public boolean containsUDF(Model model, String udfName) {
        return this.udfInformationMap.get(model).containsKey(udfName.toUpperCase());
    }

    @TestOnly
    public Map<Model, Map<String, UDFInformation>> getTable() {
        return this.udfInformationMap;
    }

    public void serializeUDFTable(OutputStream outputStream) throws IOException {
        List<UDFInformation> nonBuiltInUDFInformation = this.getAllInformationList();
        ReadWriteIOUtils.write((int)nonBuiltInUDFInformation.size(), (OutputStream)outputStream);
        for (UDFInformation udfInformation : nonBuiltInUDFInformation) {
            ReadWriteIOUtils.write((ByteBuffer)udfInformation.serialize(), (OutputStream)outputStream);
        }
    }

    public void deserializeUDFTable(InputStream inputStream) throws IOException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            UDFInformation udfInformation = UDFInformation.deserialize(inputStream);
            if (udfInformation.getUdfType().isTreeModel()) {
                this.udfInformationMap.get(Model.TREE).put(udfInformation.getFunctionName(), udfInformation);
                continue;
            }
            this.udfInformationMap.get(Model.TABLE).put(udfInformation.getFunctionName(), udfInformation);
        }
    }

    public void clear() {
        this.udfInformationMap.get(Model.TREE).clear();
        this.udfInformationMap.get(Model.TABLE).clear();
        this.functionToClassMap.get(Model.TREE).clear();
        this.functionToClassMap.get(Model.TABLE).clear();
    }
}

