/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.List;
import org.apache.iotdb.ainode.rpc.thrift.TShowModelsReq;
import org.apache.iotdb.ainode.rpc.thrift.TShowModelsResp;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ainode.AINodeClient;
import org.apache.iotdb.commons.client.ainode.AINodeClientManager;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.commons.model.ModelStatus;
import org.apache.iotdb.commons.model.ModelType;
import org.apache.iotdb.confignode.consensus.request.read.model.GetModelInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.CreateModelPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.UpdateModelInfoPlan;
import org.apache.iotdb.confignode.consensus.response.model.GetModelInfoResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.ModelInfo;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreateModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetModelInfoReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetModelInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelResp;
import org.apache.iotdb.confignode.rpc.thrift.TUpdateModelInfoReq;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelManager.class);
    private final ConfigManager configManager;
    private final ModelInfo modelInfo;

    public ModelManager(ConfigManager configManager, ModelInfo modelInfo) {
        this.configManager = configManager;
        this.modelInfo = modelInfo;
    }

    public TSStatus createModel(TCreateModelReq req) {
        if (this.modelInfo.contain(req.modelName)) {
            return new TSStatus(TSStatusCode.MODEL_EXIST_ERROR.getStatusCode()).setMessage(String.format("Model name %s already exists", req.modelName));
        }
        try {
            if (req.uri.isEmpty()) {
                return this.configManager.getConsensusManager().write(new CreateModelPlan(req.modelName));
            }
            return this.configManager.getProcedureManager().createModel(req.modelName, req.uri);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Unexpected error happened while getting model: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return res;
        }
    }

    public TSStatus dropModel(TDropModelReq req) {
        if (this.modelInfo.checkModelType(req.getModelId()) != ModelType.USER_DEFINED) {
            return new TSStatus(TSStatusCode.DROP_MODEL_ERROR.getStatusCode()).setMessage(String.format("Built-in model %s can't be removed", req.modelId));
        }
        if (!this.modelInfo.contain(req.modelId)) {
            return new TSStatus(TSStatusCode.MODEL_EXIST_ERROR.getStatusCode()).setMessage(String.format("Model name %s doesn't exists", req.modelId));
        }
        return this.configManager.getProcedureManager().dropModel(req.getModelId());
    }

    public TShowModelResp showModel(TShowModelReq req) {
        TShowModelResp tShowModelResp;
        block10: {
            List<TAINodeInfo> registeredAINodes = this.configManager.getNodeManager().getRegisteredAINodeInfoList();
            if (registeredAINodes.isEmpty()) {
                return new TShowModelResp().setStatus(new TSStatus(TSStatusCode.NO_AVAILABLE_AINODE.getStatusCode()).setMessage("Show models failed due to there is no AINode available"));
            }
            TAINodeInfo registeredAINode = registeredAINodes.get(0);
            TEndPoint targetAINodeEndPoint = new TEndPoint(registeredAINode.getInternalAddress(), registeredAINode.getInternalPort());
            AINodeClient client = (AINodeClient)AINodeClientManager.getInstance().borrowClient((Object)targetAINodeEndPoint);
            try {
                TShowModelsReq showModelsReq = new TShowModelsReq();
                if (req.isSetModelId()) {
                    showModelsReq.setModelId(req.getModelId());
                }
                TShowModelsResp resp = client.showModels(showModelsReq);
                TShowModelResp res = new TShowModelResp().setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
                res.setModelIdList(resp.getModelIdList());
                res.setModelTypeMap(resp.getModelTypeMap());
                res.setCategoryMap(resp.getCategoryMap());
                res.setStateMap(resp.getStateMap());
                tShowModelResp = res;
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to show models due to", (Throwable)e);
                    return new TShowModelResp().setStatus(new TSStatus(TSStatusCode.CAN_NOT_CONNECT_AINODE.getStatusCode()).setMessage(e.getMessage()));
                }
            }
            client.close();
        }
        return tShowModelResp;
    }

    public TGetModelInfoResp getModelInfo(TGetModelInfoReq req) {
        try {
            GetModelInfoResp response = (GetModelInfoResp)this.configManager.getConsensusManager().read(new GetModelInfoPlan(req));
            if (response.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return new TGetModelInfoResp(response.getStatus());
            }
            int aiNodeId = response.getTargetAINodeId();
            if (aiNodeId != 0) {
                response.setTargetAINodeAddress(this.configManager.getNodeManager().getRegisteredAINode(aiNodeId));
            } else {
                if (this.configManager.getNodeManager().getRegisteredAINodes().isEmpty()) {
                    return new TGetModelInfoResp(new TSStatus(TSStatusCode.GET_MODEL_INFO_ERROR.getStatusCode()).setMessage("There is no AINode available"));
                }
                response.setTargetAINodeAddress(this.configManager.getNodeManager().getRegisteredAINodes().get(0));
            }
            return response.convertToThriftResponse();
        }
        catch (ConsensusException e) {
            LOGGER.warn("Unexpected error happened while getting model: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new TGetModelInfoResp(res);
        }
    }

    public TSStatus updateModelInfo(TUpdateModelInfoReq req) {
        if (!this.modelInfo.contain(req.getModelId())) {
            return new TSStatus(TSStatusCode.MODEL_NOT_FOUND_ERROR.getStatusCode()).setMessage(String.format("Model %s doesn't exists", req.getModelId()));
        }
        try {
            ModelInformation modelInformation = new ModelInformation(ModelType.USER_DEFINED, req.getModelId());
            modelInformation.updateStatus(ModelStatus.values()[req.getModelStatus()]);
            modelInformation.setAttribute(req.getAttributes());
            modelInformation.setInputColumnSize(1);
            if (req.isSetOutputLength()) {
                modelInformation.setOutputLength(req.getOutputLength());
            }
            if (req.isSetInputLength()) {
                modelInformation.setInputLength(req.getInputLength());
            }
            UpdateModelInfoPlan updateModelInfoPlan = new UpdateModelInfoPlan(req.getModelId(), modelInformation);
            if (req.isSetAiNodeIds()) {
                updateModelInfoPlan.setNodeIds(req.getAiNodeIds());
            }
            return this.configManager.getConsensusManager().write(updateModelInfoPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Unexpected error happened while updating model info: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return res;
        }
    }

    public List<Integer> getModelDistributions(String modelName) {
        return this.modelInfo.getNodeIds(modelName);
    }
}

