/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.trigger;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.trigger.exception.TriggerManagementException;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.AddTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.DeleteTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerStateInTablePlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.state.CreateTriggerState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTriggerProcedure
extends AbstractNodeProcedure<CreateTriggerState> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateTriggerProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private TriggerInformation triggerInformation;
    private Binary jarFile;

    public CreateTriggerProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public CreateTriggerProcedure(TriggerInformation triggerInformation, Binary jarFile, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.triggerInformation = triggerInformation;
        this.jarFile = jarFile;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, CreateTriggerState state) {
        block15: {
            if (this.triggerInformation == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case INIT: {
                        LOG.info("Start to create trigger [{}]", (Object)this.triggerInformation.getTriggerName());
                        TriggerInfo triggerInfo = env.getConfigManager().getTriggerManager().getTriggerInfo();
                        triggerInfo.acquireTriggerTableLock();
                        triggerInfo.validate(this.triggerInformation.getTriggerName(), this.triggerInformation.getJarName(), this.triggerInformation.getJarFileMD5());
                        this.setNextState(CreateTriggerState.VALIDATED);
                        break;
                    }
                    case VALIDATED: {
                        ConfigManager configManager = env.getConfigManager();
                        LOG.info("Start to add trigger [{}] in TriggerTable on Config Nodes, needToSaveJar[{}]", (Object)this.triggerInformation.getTriggerName(), (Object)(this.jarFile != null ? 1 : 0));
                        TSStatus response = configManager.getConsensusManager().write(new AddTriggerInTablePlan(this.triggerInformation, this.jarFile));
                        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            throw new TriggerManagementException(response.getMessage());
                        }
                        this.setNextState(CreateTriggerState.CONFIG_NODE_INACTIVE);
                        break;
                    }
                    case CONFIG_NODE_INACTIVE: {
                        LOG.info("Start to create triggerInstance [{}] on Data Nodes", (Object)this.triggerInformation.getTriggerName());
                        if (RpcUtils.squashResponseStatusList(env.createTriggerOnDataNodes(this.triggerInformation, this.jarFile)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            this.setNextState(CreateTriggerState.DATA_NODE_INACTIVE);
                            break;
                        }
                        throw new TriggerManagementException(String.format("Fail to create triggerInstance [%s] on Data Nodes", this.triggerInformation.getTriggerName()));
                    }
                    case DATA_NODE_INACTIVE: {
                        LOG.info("Start to active trigger [{}] on Data Nodes", (Object)this.triggerInformation.getTriggerName());
                        if (RpcUtils.squashResponseStatusList(env.activeTriggerOnDataNodes(this.triggerInformation.getTriggerName())).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            this.setNextState(CreateTriggerState.DATA_NODE_ACTIVE);
                            break;
                        }
                        throw new TriggerManagementException(String.format("Fail to active triggerInstance [%s] on Data Nodes", this.triggerInformation.getTriggerName()));
                    }
                    case DATA_NODE_ACTIVE: {
                        LOG.info("Start to active trigger [{}] on Config Nodes", (Object)this.triggerInformation.getTriggerName());
                        env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(new UpdateTriggerStateInTablePlan(this.triggerInformation.getTriggerName(), TTriggerState.ACTIVE)) : new UpdateTriggerStateInTablePlan(this.triggerInformation.getTriggerName(), TTriggerState.ACTIVE));
                        this.setNextState(CreateTriggerState.CONFIG_NODE_ACTIVE);
                        break;
                    }
                    case CONFIG_NODE_ACTIVE: {
                        env.getConfigManager().getTriggerManager().getTriggerInfo().releaseTriggerTableLock();
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown CreateTriggerState: " + (Object)((Object)state));
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    LOG.warn("Create trigger {} failed.", (Object)this.triggerInformation.getTriggerName(), (Object)e);
                    this.setFailure(new ProcedureException(e));
                }
                LOG.error("Retrievable error trying to create trigger [{}], state [{}]", new Object[]{this.triggerInformation.getTriggerName(), state, e});
                if (this.getCycles() <= 5) break block15;
                this.setFailure(new ProcedureException(String.format("Fail to create trigger [%s] at STATE [%s]", new Object[]{this.triggerInformation.getTriggerName(), state})));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, CreateTriggerState state) throws IOException, InterruptedException, ProcedureException {
        switch (state) {
            case INIT: {
                LOG.info("Start [INIT] rollback of trigger [{}]", (Object)this.triggerInformation.getTriggerName());
                env.getConfigManager().getTriggerManager().getTriggerInfo().releaseTriggerTableLock();
                break;
            }
            case VALIDATED: {
                LOG.info("Start [VALIDATED] rollback of trigger [{}]", (Object)this.triggerInformation.getTriggerName());
                try {
                    env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(new DeleteTriggerInTablePlan(this.triggerInformation.getTriggerName())) : new DeleteTriggerInTablePlan(this.triggerInformation.getTriggerName()));
                }
                catch (ConsensusException e) {
                    LOG.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
                }
                break;
            }
            case CONFIG_NODE_INACTIVE: {
                LOG.info("Start to [CONFIG_NODE_INACTIVE] rollback of trigger [{}]", (Object)this.triggerInformation.getTriggerName());
                if (RpcUtils.squashResponseStatusList(env.dropTriggerOnDataNodes(this.triggerInformation.getTriggerName(), false)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                throw new TriggerManagementException(String.format("Fail to [CONFIG_NODE_INACTIVE] rollback of trigger [%s]", this.triggerInformation.getTriggerName()));
            }
            case DATA_NODE_INACTIVE: {
                LOG.info("Start to [DATA_NODE_INACTIVE] rollback of trigger [{}]", (Object)this.triggerInformation.getTriggerName());
                if (RpcUtils.squashResponseStatusList(env.inactiveTriggerOnDataNodes(this.triggerInformation.getTriggerName())).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                throw new TriggerManagementException(String.format("Fail to [DATA_NODE_INACTIVE] rollback of trigger [%s]", this.triggerInformation.getTriggerName()));
            }
        }
    }

    @Override
    protected boolean isRollbackSupported(CreateTriggerState state) {
        return true;
    }

    @Override
    protected CreateTriggerState getState(int stateId) {
        return CreateTriggerState.values()[stateId];
    }

    @Override
    protected int getStateId(CreateTriggerState createTriggerState) {
        return createTriggerState.ordinal();
    }

    @Override
    protected CreateTriggerState getInitialState() {
        return CreateTriggerState.INIT;
    }

    public Binary getJarFile() {
        return this.jarFile;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_CREATE_TRIGGER_PROCEDURE.getTypeCode() : ProcedureType.CREATE_TRIGGER_PROCEDURE.getTypeCode());
        super.serialize(stream);
        this.triggerInformation.serialize(stream);
        if (this.jarFile == null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
            ReadWriteIOUtils.write((Binary)this.jarFile, (OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.triggerInformation = TriggerInformation.deserialize((ByteBuffer)byteBuffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            return;
        }
        this.jarFile = ReadWriteIOUtils.readBinary((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object that) {
        if (that instanceof CreateTriggerProcedure) {
            CreateTriggerProcedure thatProc = (CreateTriggerProcedure)that;
            return thatProc.getProcId() == this.getProcId() && ((CreateTriggerState)((Object)thatProc.getCurrentState())).equals(this.getCurrentState()) && thatProc.getCycles() == this.getCycles() && thatProc.isGeneratedByPipe == this.isGeneratedByPipe && thatProc.triggerInformation.equals((Object)this.triggerInformation);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.isGeneratedByPipe, this.triggerInformation);
    }
}

