/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common;

import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.utils.PathUtils;

public abstract class PipeInsertionEvent
extends EnrichedEvent {
    private final String sourceDatabaseNameFromDataRegion;
    protected Boolean isTableModelEvent;
    protected String treeModelDatabaseName;
    protected String tableModelDatabaseName;

    protected PipeInsertionEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, String userName, boolean skipIfNoPrivileges, long startTime, long endTime, Boolean isTableModelEvent, String databaseNameFromDataRegion, String tableModelDatabaseName, String treeModelDatabaseName) {
        super(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, userName, skipIfNoPrivileges, startTime, endTime);
        this.isTableModelEvent = isTableModelEvent;
        this.sourceDatabaseNameFromDataRegion = databaseNameFromDataRegion;
        this.treeModelDatabaseName = treeModelDatabaseName;
        if (tableModelDatabaseName != null) {
            this.tableModelDatabaseName = tableModelDatabaseName.toLowerCase();
        }
    }

    protected PipeInsertionEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, String userName, boolean skipIfNoPrivileges, long startTime, long endTime, Boolean isTableModelEvent, String databaseNameFromDataRegion) {
        this(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, userName, skipIfNoPrivileges, startTime, endTime, isTableModelEvent, databaseNameFromDataRegion, null, null);
    }

    public void markAsTableModelEvent() {
        this.isTableModelEvent = Boolean.TRUE;
    }

    public void markAsTreeModelEvent() {
        this.isTableModelEvent = Boolean.FALSE;
    }

    public boolean isTableModelEvent() {
        if (this.isTableModelEvent == null) {
            if (this.sourceDatabaseNameFromDataRegion == null) {
                throw new IllegalStateException("databaseNameFromDataRegion is null");
            }
            this.isTableModelEvent = PathUtils.isTableModelDatabase((String)this.sourceDatabaseNameFromDataRegion);
            return this.isTableModelEvent;
        }
        return this.isTableModelEvent;
    }

    public Boolean getRawIsTableModelEvent() {
        return this.isTableModelEvent;
    }

    public String getSourceDatabaseNameFromDataRegion() {
        return this.sourceDatabaseNameFromDataRegion;
    }

    public String getRawTableModelDataBase() {
        return this.tableModelDatabaseName;
    }

    public String getRawTreeModelDataBase() {
        return this.treeModelDatabaseName;
    }

    public String getTreeModelDatabaseName() {
        return this.treeModelDatabaseName == null ? (this.treeModelDatabaseName = PathUtils.qualifyDatabaseName((String)this.sourceDatabaseNameFromDataRegion)) : this.treeModelDatabaseName;
    }

    public String getTableModelDatabaseName() {
        return this.tableModelDatabaseName == null ? (this.tableModelDatabaseName = PathUtils.unQualifyDatabaseName((String)this.sourceDatabaseNameFromDataRegion)) : this.tableModelDatabaseName;
    }

    public void renameTableModelDatabase(@NotNull String tableModelDatabaseName) {
        this.tableModelDatabaseName = tableModelDatabaseName.toLowerCase();
        this.treeModelDatabaseName = PathUtils.qualifyDatabaseName((String)tableModelDatabaseName);
    }
}

