/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.BitMap;

public class CountAccumulator
implements Accumulator {
    private long countValue = 0L;

    @Override
    public void addInput(Column[] columns, BitMap bitMap) {
        int count = columns[0].getPositionCount();
        if (!columns[1].mayHaveNull() && (bitMap == null || bitMap.isAllMarked())) {
            this.countValue += (long)count;
        } else {
            for (int i = 0; i < count; ++i) {
                if (bitMap != null && !bitMap.isMarked(i) || columns[1].isNull(i)) continue;
                ++this.countValue;
            }
        }
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Count should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.countValue += partialResult[0].getLong(0);
    }

    @Override
    public void removeIntermediate(Column[] input) {
        Preconditions.checkArgument((input.length == 1 ? 1 : 0) != 0, (Object)"input of Count should be 1");
        if (input[0].isNull(0)) {
            return;
        }
        this.countValue -= input[0].getLong(0);
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        this.countValue += (long)statistics.getCount();
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.countValue = finalResult.getLong(0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Count should be 1");
        columnBuilders[0].writeLong(this.countValue);
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countValue);
    }

    @Override
    public void reset() {
        this.countValue = 0L;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.INT64;
    }
}

