/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule;

import org.apache.iotdb.commons.exception.QueryTimeoutException;
import org.apache.iotdb.db.queryengine.execution.schedule.AbstractDriverThread;
import org.apache.iotdb.db.queryengine.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.queryengine.execution.schedule.ThreadProducer;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverTaskTimeoutSentinelThread
extends AbstractDriverThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverTaskTimeoutSentinelThread.class);
    private static final long SLEEP_BOUND = 5000L;

    public DriverTaskTimeoutSentinelThread(String workerId, ThreadGroup tg, IndexedBlockingQueue<DriverTask> queue, ITaskScheduler scheduler, ThreadProducer producer) {
        super(workerId, tg, queue, scheduler, producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DriverTask task) throws InterruptedException {
        long startSleep;
        task.lock();
        try {
            if (task.isEndState()) {
                return;
            }
        }
        finally {
            task.unlock();
        }
        for (long waitTime = Math.min(task.getDDL() - System.currentTimeMillis(), 5000L); waitTime > 0L; waitTime -= System.currentTimeMillis() - startSleep) {
            startSleep = System.currentTimeMillis();
            Thread.sleep(waitTime);
        }
        task.lock();
        try {
            if (task.isEndState()) {
                return;
            }
            if (task.getDDL() - System.currentTimeMillis() > 0L) {
                this.scheduler.enforceTimeLimit(task);
                return;
            }
        }
        finally {
            task.unlock();
        }
        LOGGER.warn("[DriverTaskTimeout] Current time is {}, ddl of task is {}", (Object)System.currentTimeMillis(), (Object)task.getDDL());
        task.setAbortCause((Throwable)new QueryTimeoutException());
        this.scheduler.toAborted(task);
    }
}

