/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.function.Function;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheSizeComputerImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCacheImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCachePolicy;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.FIFOCacheEntryManager;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.LRUCacheEntryManager;

public class DualKeyCacheBuilder<FK, SK, V> {
    private DualKeyCachePolicy policy;
    private long memoryCapacity;
    private Function<FK, Integer> firstKeySizeComputer;
    private Function<SK, Integer> secondKeySizeComputer;
    private Function<V, Integer> valueSizeComputer;

    public IDualKeyCache<FK, SK, V> build() {
        ICacheEntryManager cacheEntryManager = null;
        switch (this.policy) {
            case LRU: {
                cacheEntryManager = new LRUCacheEntryManager();
                break;
            }
            case FIFO: {
                cacheEntryManager = new FIFOCacheEntryManager();
            }
        }
        return new DualKeyCacheImpl(cacheEntryManager, new CacheSizeComputerImpl<FK, SK, V>(this.firstKeySizeComputer, this.secondKeySizeComputer, this.valueSizeComputer), this.memoryCapacity);
    }

    public DualKeyCacheBuilder<FK, SK, V> cacheEvictionPolicy(DualKeyCachePolicy policy) {
        this.policy = policy;
        return this;
    }

    public DualKeyCacheBuilder<FK, SK, V> memoryCapacity(long memoryCapacity) {
        this.memoryCapacity = memoryCapacity;
        return this;
    }

    public DualKeyCacheBuilder<FK, SK, V> firstKeySizeComputer(Function<FK, Integer> computer) {
        this.firstKeySizeComputer = computer;
        return this;
    }

    public DualKeyCacheBuilder<FK, SK, V> secondKeySizeComputer(Function<SK, Integer> computer) {
        this.secondKeySizeComputer = computer;
        return this;
    }

    public DualKeyCacheBuilder<FK, SK, V> valueSizeComputer(Function<V, Integer> computer) {
        this.valueSizeComputer = computer;
        return this;
    }
}

