/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.PipeFunctionSupport;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipe;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.CreatePipeStatement;

public class CreatePipeTask
implements IConfigTask {
    private final CreatePipeStatement createPipeStatement;

    public CreatePipeTask(CreatePipeStatement createPipeStatement) {
        this.applyNowFunctionToExtractorAttributes(createPipeStatement.getExtractorAttributes());
        this.createPipeStatement = createPipeStatement;
    }

    public CreatePipeTask(CreatePipe createPipe) {
        this.createPipeStatement = new CreatePipeStatement(StatementType.CREATE_PIPE);
        this.createPipeStatement.setPipeName(createPipe.getPipeName());
        this.createPipeStatement.setIfNotExists(createPipe.hasIfNotExistsCondition());
        this.applyNowFunctionToExtractorAttributes(createPipe.getExtractorAttributes());
        this.createPipeStatement.setExtractorAttributes(createPipe.getExtractorAttributes());
        this.createPipeStatement.setProcessorAttributes(createPipe.getProcessorAttributes());
        this.createPipeStatement.setConnectorAttributes(createPipe.getConnectorAttributes());
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.createPipe(this.createPipeStatement);
    }

    private void applyNowFunctionToExtractorAttributes(Map<String, String> attributes) {
        long currentTime = CommonDateTimeUtils.convertMilliTimeWithPrecision((long)System.currentTimeMillis(), (String)CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        PipeFunctionSupport.applyNowFunctionToExtractorAttributes(attributes, "source.start-time", "extractor.start-time", currentTime);
        PipeFunctionSupport.applyNowFunctionToExtractorAttributes(attributes, "source.end-time", "extractor.end-time", currentTime);
        PipeFunctionSupport.applyNowFunctionToExtractorAttributes(attributes, "source.history.start-time", "extractor.history.start-time", currentTime);
        PipeFunctionSupport.applyNowFunctionToExtractorAttributes(attributes, "source.history.end-time", "extractor.history.end-time", currentTime);
    }
}

