/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.unary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.tsfile.utils.RamUsageEstimator;

public class NegationExpression
extends UnaryExpression {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(NegationExpression.class);

    public NegationExpression(Expression expression) {
        super(expression);
    }

    public NegationExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
    }

    @Override
    public String getExpressionStringInternal() {
        return this.expression instanceof TimeSeriesOperand || this.expression instanceof FunctionExpression || this.expression instanceof NullOperand || this.expression instanceof ConstantOperand && !((ConstantOperand)this.expression).isNegativeNumber() ? "-" + this.expression.getExpressionString() : "-(" + this.expression.getExpressionString() + ")";
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.expression instanceof TimeSeriesOperand || this.expression instanceof FunctionExpression || this.expression instanceof NullOperand || this.expression instanceof ConstantOperand && !((ConstantOperand)this.expression).isNegativeNumber() ? "-" + this.expression.getOutputSymbol() : "-(" + this.expression.getOutputSymbol() + ")";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.NEGATION;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitNegationExpression(this, context);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.expression);
    }
}

