/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class OrderingScheme {
    private final List<Symbol> orderBy;
    private final Map<Symbol, SortOrder> orderings;

    public OrderingScheme(List<Symbol> orderBy, Map<Symbol, SortOrder> orderings) {
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(orderings, "orderings is null");
        Preconditions.checkArgument((!orderBy.isEmpty() ? 1 : 0) != 0, (Object)"orderBy is empty");
        Preconditions.checkArgument((boolean)orderings.keySet().equals(ImmutableSet.copyOf(orderBy)), (Object)"orderBy keys and orderings don't match");
        this.orderBy = ImmutableList.copyOf(orderBy);
        this.orderings = ImmutableMap.copyOf(orderings);
    }

    public List<Symbol> getOrderBy() {
        return this.orderBy;
    }

    public Map<Symbol, SortOrder> getOrderings() {
        return this.orderings;
    }

    public List<SortOrder> getOrderingList() {
        return (List)this.orderBy.stream().map(this.orderings::get).collect(ImmutableList.toImmutableList());
    }

    public SortOrder getOrdering(Symbol symbol) {
        Preconditions.checkArgument((boolean)this.orderings.containsKey(symbol), (String)"No ordering for symbol: %s", (Object)symbol);
        return this.orderings.get(symbol);
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.orderBy.size(), (ByteBuffer)byteBuffer);
        for (Symbol symbol : this.orderBy) {
            Symbol.serialize(symbol, byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.orderings.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry entry : this.orderings.entrySet()) {
            Symbol.serialize((Symbol)entry.getKey(), byteBuffer);
            ReadWriteIOUtils.write((int)((SortOrder)((Object)entry.getValue())).ordinal(), (ByteBuffer)byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.orderBy.size(), (OutputStream)stream);
        for (Symbol symbol : this.orderBy) {
            Symbol.serialize(symbol, stream);
        }
        ReadWriteIOUtils.write((int)this.orderings.size(), (OutputStream)stream);
        for (Map.Entry entry : this.orderings.entrySet()) {
            Symbol.serialize((Symbol)entry.getKey(), stream);
            ReadWriteIOUtils.write((int)((SortOrder)((Object)entry.getValue())).ordinal(), (OutputStream)stream);
        }
    }

    public static OrderingScheme deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> orderBy = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            orderBy.add(Symbol.deserialize(byteBuffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>(size);
        while (size-- > 0) {
            orderings.put(Symbol.deserialize(byteBuffer), SortOrder.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)]);
        }
        return new OrderingScheme(orderBy, orderings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderingScheme that = (OrderingScheme)o;
        return Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.orderings, that.orderings);
    }

    public int hashCode() {
        return Objects.hash(this.orderBy, this.orderings);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("orderBy", this.orderBy).add("orderings", this.orderings).toString();
    }
}

