/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationType;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlanBuilder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.QueryPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.RelationPlan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.RelationPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ScopeAware;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.TranslationMap;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ApplyNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.EnforceSingleRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataTypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericDataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.Type;

class SubqueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final QueryId idAllocator;
    private final MPPQueryContext plannerContext;
    private final SessionInfo session;
    private final Map<NodeRef<Node>, RelationPlan> recursiveSubqueries;

    SubqueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, MPPQueryContext plannerContext, Optional<TranslationMap> outerContext, SessionInfo session, Map<NodeRef<Node>, RelationPlan> recursiveSubqueries) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(recursiveSubqueries, "recursiveSubqueries is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = plannerContext.getQueryId();
        this.plannerContext = plannerContext;
        this.session = session;
        this.recursiveSubqueries = recursiveSubqueries;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Collection<Expression> expressions, Analysis.SubqueryAnalysis subqueries) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, subqueries);
        }
        return builder;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Analysis.SubqueryAnalysis subqueries) {
        List<QuantifiedComparisonExpression> list;
        List<ExistsPredicate> list2;
        List<SubqueryExpression> scalarSubqueries;
        List<InPredicate> inPredicates = subqueries.getInPredicatesSubqueries();
        if (!inPredicates.isEmpty()) {
            for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, inPredicates))) {
                builder = this.planInPredicate(builder, cluster, subqueries);
            }
        }
        if (!(scalarSubqueries = subqueries.getSubqueries()).isEmpty()) {
            for (Cluster<SubqueryExpression> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, scalarSubqueries))) {
                builder = this.planScalarSubquery(builder, cluster);
            }
        }
        if (!(list2 = subqueries.getExistsSubqueries()).isEmpty()) {
            for (Cluster<ExistsPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, list2))) {
                builder = this.planExists(builder, cluster);
            }
        }
        if (!(list = subqueries.getQuantifiedComparisonSubqueries()).isEmpty()) {
            for (Cluster<QuantifiedComparisonExpression> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, list))) {
                builder = this.planQuantifiedComparison(builder, cluster, subqueries);
            }
        }
        return builder;
    }

    private <T extends Expression> List<T> selectSubqueries(PlanBuilder subPlan, Expression parent, List<T> candidates) {
        SuccessorsFunction recurse = expression -> {
            if (!(expression instanceof Expression) || !this.analysis.isColumnReference((Expression)expression) && !subPlan.canTranslate((Expression)expression)) {
                return expression.getChildren();
            }
            return ImmutableList.of();
        };
        Iterable allSubExpressions = Traverser.forTree((SuccessorsFunction)recurse).depthFirstPreOrder((Object)parent);
        return (List)candidates.stream().filter(candidate -> Streams.stream((Iterable)allSubExpressions).anyMatch(child -> child == candidate)).filter(candidate -> !subPlan.canTranslate((Expression)candidate)).collect(ImmutableList.toImmutableList());
    }

    private <T extends Expression> Collection<Cluster<T>> cluster(Scope scope, List<T> expressions) {
        LinkedHashMap<ScopeAware, List> sets = new LinkedHashMap<ScopeAware, List>();
        for (Expression expression : expressions) {
            sets.computeIfAbsent(ScopeAware.scopeAwareKey(expression, this.analysis, scope), key -> new ArrayList()).add(expression);
        }
        return (Collection)sets.values().stream().map(cluster -> Cluster.newCluster(cluster, scope, this.analysis)).collect(ImmutableList.toImmutableList());
    }

    private PlanBuilder planInPredicate(PlanBuilder subPlan, Cluster<InPredicate> cluster, Analysis.SubqueryAnalysis subqueries) {
        InPredicate predicate = cluster.getRepresentative();
        Expression value = predicate.getValue();
        SubqueryExpression subquery = (SubqueryExpression)predicate.getValueList();
        Symbol output = this.symbolAllocator.newSymbol(predicate, (Type)BooleanType.BOOLEAN);
        subPlan = this.handleSubqueries(subPlan, value, subqueries);
        subPlan = this.planInPredicate(subPlan, value, subquery, output, predicate, this.analysis.getPredicateCoercions(predicate));
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
    }

    private PlanBuilder planInPredicate(PlanBuilder subPlan, Expression value, SubqueryExpression subquery, Symbol output, Expression originalExpression, Analysis.PredicateCoercions predicateCoercions) {
        QueryPlanner.PlanAndMappings subqueryPlan = this.planSubquery(subquery, predicateCoercions.getSubqueryCoercion(), subPlan.getTranslations());
        QueryPlanner.PlanAndMappings valuePlan = this.planValue(subPlan, value, predicateCoercions.getValueType(), predicateCoercions.getValueCoercion());
        return new PlanBuilder(valuePlan.getSubPlan().getTranslations(), new ApplyNode(this.idAllocator.genPlanNodeId(), valuePlan.getSubPlan().getRoot(), subqueryPlan.getSubPlan().getRoot(), (Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)output, (Object)new ApplyNode.In(valuePlan.get(value), subqueryPlan.get(subquery))), valuePlan.getSubPlan().getRoot().getOutputSymbols(), originalExpression));
    }

    private PlanBuilder planScalarSubquery(PlanBuilder subPlan, Cluster<SubqueryExpression> cluster) {
        SubqueryExpression scalarSubquery = cluster.getRepresentative();
        RelationPlan relationPlan = this.planSubquery(scalarSubquery, subPlan.getTranslations());
        PlanBuilder subqueryPlan = PlanBuilder.newPlanBuilder(relationPlan, this.analysis);
        EnforceSingleRowNode root = new EnforceSingleRowNode(this.idAllocator.genPlanNodeId(), subqueryPlan.getRoot());
        Type type = this.analysis.getType(scalarSubquery);
        RelationType descriptor = relationPlan.getDescriptor();
        List<Symbol> fieldMappings = relationPlan.getFieldMappings();
        Preconditions.checkArgument((descriptor.getVisibleFieldCount() <= 1 ? 1 : 0) != 0, (Object)"For now, only single column subqueries are supported");
        Symbol column = (Symbol)Iterables.getOnlyElement(fieldMappings);
        return this.appendCorrelatedJoin(subPlan, root, scalarSubquery.getQuery(), JoinNode.JoinType.INNER, BooleanLiteral.TRUE_LITERAL, this.mapAll(cluster, subPlan.getScope(), column));
    }

    public PlanBuilder appendCorrelatedJoin(PlanBuilder subPlan, PlanNode subquery, Query query, JoinNode.JoinType type, Expression filterCondition, Map<ScopeAware<Expression>, Symbol> mappings) {
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(mappings), new CorrelatedJoinNode(this.idAllocator.genPlanNodeId(), subPlan.getRoot(), subquery, subPlan.getRoot().getOutputSymbols(), type, filterCondition, query));
    }

    private PlanBuilder planExists(PlanBuilder subPlan, Cluster<ExistsPredicate> cluster) {
        ExistsPredicate existsPredicate = cluster.getRepresentative();
        Expression subquery = existsPredicate.getSubquery();
        Symbol exists = this.symbolAllocator.newSymbol("exists", (Type)BooleanType.BOOLEAN);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), exists)), new ApplyNode(this.idAllocator.genPlanNodeId(), subPlan.getRoot(), this.planSubquery(subquery, subPlan.getTranslations()).getRoot(), (Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)exists, (Object)new ApplyNode.Exists()), subPlan.getRoot().getOutputSymbols(), subquery));
    }

    private RelationPlan planSubquery(Expression subquery, TranslationMap outerContext) {
        return (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.plannerContext, Optional.of(outerContext), this.session, this.recursiveSubqueries).process(subquery, null);
    }

    private PlanBuilder planQuantifiedComparison(PlanBuilder subPlan, Cluster<QuantifiedComparisonExpression> cluster, Analysis.SubqueryAnalysis subqueries) {
        QuantifiedComparisonExpression quantifiedComparison = cluster.getRepresentative();
        ComparisonExpression.Operator operator = quantifiedComparison.getOperator();
        QuantifiedComparisonExpression.Quantifier quantifier = quantifiedComparison.getQuantifier();
        Expression value = quantifiedComparison.getValue();
        SubqueryExpression subquery = (SubqueryExpression)quantifiedComparison.getSubquery();
        subPlan = this.handleSubqueries(subPlan, value, subqueries);
        Symbol output = this.symbolAllocator.newSymbol(quantifiedComparison, (Type)BooleanType.BOOLEAN);
        Analysis.PredicateCoercions predicateCoercions = this.analysis.getPredicateCoercions(quantifiedComparison);
        switch (operator) {
            case EQUAL: {
                switch (quantifier) {
                    case ALL: {
                        subPlan = this.planQuantifiedComparison(subPlan, operator, quantifier, value, subquery, output, predicateCoercions);
                        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(quantifiedComparison, this.analysis, subPlan.getScope()), (Object)output)), subPlan.getRoot());
                    }
                    case ANY: 
                    case SOME: {
                        subPlan = this.planInPredicate(subPlan, value, subquery, output, quantifiedComparison, predicateCoercions);
                        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
                    }
                }
                throw new IllegalArgumentException();
            }
            case NOT_EQUAL: {
                switch (quantifier) {
                    case ALL: {
                        return this.addNegation(this.planInPredicate(subPlan, value, subquery, output, quantifiedComparison, predicateCoercions), cluster, output);
                    }
                    case ANY: 
                    case SOME: {
                        return this.addNegation(this.planQuantifiedComparison(subPlan, ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, value, subquery, output, predicateCoercions), cluster, output);
                    }
                }
                throw new IllegalArgumentException();
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                subPlan = this.planQuantifiedComparison(subPlan, operator, quantifier, value, subquery, output, predicateCoercions);
                return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected quantified comparison: '%s %s'", new Object[]{operator.getValue(), quantifier}));
    }

    private PlanBuilder addNegation(PlanBuilder subPlan, Cluster<? extends Expression> cluster, Symbol input) {
        Symbol output = this.symbolAllocator.newSymbol("not", (Type)BooleanType.BOOLEAN);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), new ProjectNode(this.idAllocator.genPlanNodeId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(output, new NotExpression(input.toSymbolReference())).build()));
    }

    private PlanBuilder planQuantifiedComparison(PlanBuilder subPlan, ComparisonExpression.Operator operator, QuantifiedComparisonExpression.Quantifier quantifier, Expression value, Expression subquery, Symbol assignment, Analysis.PredicateCoercions predicateCoercions) {
        QueryPlanner.PlanAndMappings subqueryPlan = this.planSubquery(subquery, predicateCoercions.getSubqueryCoercion(), subPlan.getTranslations());
        QueryPlanner.PlanAndMappings valuePlan = this.planValue(subPlan, value, predicateCoercions.getValueType(), predicateCoercions.getValueCoercion());
        return new PlanBuilder(valuePlan.getSubPlan().getTranslations(), new ApplyNode(this.idAllocator.genPlanNodeId(), valuePlan.getSubPlan().getRoot(), subqueryPlan.getSubPlan().getRoot(), (Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)assignment, (Object)new ApplyNode.QuantifiedComparison(SubqueryPlanner.mapOperator(operator), SubqueryPlanner.mapQuantifier(quantifier), valuePlan.get(value), subqueryPlan.get(subquery))), valuePlan.getSubPlan().getRoot().getOutputSymbols(), subquery));
    }

    private static ApplyNode.Quantifier mapQuantifier(QuantifiedComparisonExpression.Quantifier quantifier) {
        switch (quantifier) {
            case ALL: {
                return ApplyNode.Quantifier.ALL;
            }
            case ANY: {
                return ApplyNode.Quantifier.ANY;
            }
            case SOME: {
                return ApplyNode.Quantifier.SOME;
            }
        }
        throw new IllegalArgumentException();
    }

    private static ApplyNode.Operator mapOperator(ComparisonExpression.Operator operator) {
        switch (operator) {
            case EQUAL: {
                return ApplyNode.Operator.EQUAL;
            }
            case NOT_EQUAL: {
                return ApplyNode.Operator.NOT_EQUAL;
            }
            case LESS_THAN: {
                return ApplyNode.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return ApplyNode.Operator.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return ApplyNode.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return ApplyNode.Operator.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException();
    }

    private QueryPlanner.PlanAndMappings planValue(PlanBuilder subPlan, Expression value, Type actualType, Optional<Type> coercion) {
        subPlan = subPlan.appendProjections(ImmutableList.of((Object)value), this.symbolAllocator, this.plannerContext);
        Symbol column = subPlan.translate(value);
        Type declaredType = this.analysis.getType(value);
        if (!actualType.equals(declaredType)) {
            Symbol wrapped = this.symbolAllocator.newSymbol("row", actualType);
            Assignments assignments = Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(wrapped, column.toSymbolReference()).build();
            subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.genPlanNodeId(), subPlan.getRoot(), assignments));
            column = wrapped;
        }
        return this.coerceIfNecessary(subPlan, column, value, coercion);
    }

    private QueryPlanner.PlanAndMappings planSubquery(Expression subquery, Optional<Type> coercion, TranslationMap outerContext) {
        Type type = this.analysis.getType(subquery);
        Symbol column = this.symbolAllocator.newSymbol("row", type);
        RelationPlan relationPlan = this.planSubquery(subquery, outerContext);
        PlanBuilder subqueryPlan = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(subquery, this.analysis, relationPlan.getScope()), (Object)column));
        RelationType descriptor = relationPlan.getDescriptor();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (int i = 0; i < descriptor.getAllFieldCount(); ++i) {
            Field field = descriptor.getFieldByIndex(i);
            if (field.isHidden()) continue;
            fields.add((Object)relationPlan.getFieldMappings().get(i).toSymbolReference());
        }
        ImmutableList fieldsList = fields.build();
        Preconditions.checkArgument((fieldsList.size() == 1 ? 1 : 0) != 0, (Object)"For now, only single column subqueries are supported.");
        subqueryPlan = subqueryPlan.withNewRoot(new ProjectNode(this.idAllocator.genPlanNodeId(), relationPlan.getRoot(), Assignments.of(column, (Expression)fieldsList.get(0))));
        return this.coerceIfNecessary(subqueryPlan, column, subquery, coercion);
    }

    private QueryPlanner.PlanAndMappings coerceIfNecessary(PlanBuilder subPlan, Symbol symbol, Expression value, Optional<? extends Type> coercion) {
        Symbol coerced = symbol;
        if (coercion.isPresent()) {
            coerced = this.symbolAllocator.newSymbol(value, coercion.get());
            Assignments assignments = Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(coerced, new Cast(symbol.toSymbolReference(), new GenericDataType(new Identifier(coercion.get().toString()), (List<DataTypeParameter>)ImmutableList.of()), false)).build();
            subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.genPlanNodeId(), subPlan.getRoot(), assignments));
        }
        return new QueryPlanner.PlanAndMappings(subPlan, (Map<NodeRef<Expression>, Symbol>)ImmutableMap.of(NodeRef.of(value), (Object)coerced));
    }

    private <T extends Expression> Map<ScopeAware<Expression>, Symbol> mapAll(Cluster<T> cluster, Scope scope, Symbol output) {
        return (Map)cluster.getExpressions().stream().collect(ImmutableMap.toImmutableMap(expression -> ScopeAware.scopeAwareKey(expression, this.analysis, scope), expression -> output, (first, second) -> first));
    }

    private static class Cluster<T extends Expression> {
        private final List<T> expressions;

        private Cluster(List<T> expressions) {
            Preconditions.checkArgument((!expressions.isEmpty() ? 1 : 0) != 0, (Object)"Cluster is empty");
            this.expressions = ImmutableList.copyOf(expressions);
        }

        public static <T extends Expression> Cluster<T> newCluster(List<T> expressions, Scope scope, Analysis analysis) {
            long count = expressions.stream().map(expression -> ScopeAware.scopeAwareKey(expression, analysis, scope)).distinct().count();
            Preconditions.checkArgument((count == 1L ? 1 : 0) != 0, (Object)"Cluster contains expressions that are not equivalent to each other");
            return new Cluster<T>(expressions);
        }

        public List<T> getExpressions() {
            return this.expressions;
        }

        public T getRepresentative() {
            return (T)((Expression)this.expressions.get(0));
        }
    }
}

