/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.Util;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class PruneAggregationSourceColumns
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{aggregationNode.getGroupingKeys().stream(), aggregationNode.getHashSymbol().map(Stream::of).orElseGet(Stream::empty), aggregationNode.getAggregations().values().stream().flatMap(aggregation -> SymbolsExtractor.extractUnique(aggregation).stream())}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(context.getIdAllocator(), aggregationNode, requiredInputs).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

