/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPatternVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class IrLabel
extends IrRowPattern {
    private final String name;

    public IrLabel(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(IrRowPatternVisitor<R, C> visitor, C context) {
        return visitor.visitIrLabel(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrLabel o = (IrLabel)obj;
        return Objects.equals(this.name, o.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }

    public static void serialize(IrLabel label, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)label.name, (ByteBuffer)byteBuffer);
    }

    public static void serialize(IrLabel label, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)label.name, (OutputStream)stream);
    }

    public static IrLabel deserialize(ByteBuffer byteBuffer) {
        String name = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        return new IrLabel(name);
    }
}

