/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DoubleLiteral
extends Literal {
    private final double value;

    public DoubleLiteral(String value) {
        super(null);
        this.value = Double.parseDouble(Objects.requireNonNull(value, "value is null"));
    }

    public DoubleLiteral(double value) {
        super(null);
        this.value = value;
    }

    public DoubleLiteral(NodeLocation location, String value) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Double.parseDouble(Objects.requireNonNull(value, "value is null"));
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDoubleLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleLiteral that = (DoubleLiteral)o;
        return Double.compare(that.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!DoubleLiteral.sameClass(this, other)) {
            return false;
        }
        return this.value == ((DoubleLiteral)other).value;
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.DOUBLE_LITERAL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((double)this.value, (OutputStream)stream);
    }

    public DoubleLiteral(ByteBuffer byteBuffer) {
        super(null);
        this.value = ReadWriteIOUtils.readDouble((ByteBuffer)byteBuffer);
    }

    @Override
    public Object getTsValue() {
        return this.value;
    }
}

