/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.ParsingException;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class GenericLiteral
extends Literal {
    private final String type;
    private final String value;

    public GenericLiteral(String type, String value) {
        super(null);
        this.type = Objects.requireNonNull(type, "type is null");
        if (type.equalsIgnoreCase("X")) {
            throw new ParsingException("Spaces are not allowed between 'X' and the starting quote of a binary literal");
        }
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public GenericLiteral(NodeLocation location, String type, String value) {
        super(Objects.requireNonNull(location, "location is null"));
        this.type = Objects.requireNonNull(type, "type is null");
        if (type.equalsIgnoreCase("X")) {
            throw new ParsingException("Spaces are not allowed between 'X' and the starting quote of a binary literal", location);
        }
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGenericLiteral(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GenericLiteral other = (GenericLiteral)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!GenericLiteral.sameClass(this, other)) {
            return false;
        }
        GenericLiteral otherLiteral = (GenericLiteral)other;
        return this.value.equals(otherLiteral.value) && this.type.equals(otherLiteral.type);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.GENERIC_LITERAL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.type, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
    }

    public GenericLiteral(ByteBuffer byteBuffer) {
        super(null);
        this.type = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    @Override
    public Object getTsValue() {
        return new Binary(this.value.getBytes(StandardCharsets.UTF_8));
    }
}

