/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class SetColumnComment
extends Statement {
    private final QualifiedName table;
    private final Identifier field;
    private final boolean tableIfExists;
    private final boolean columnIfExists;
    @Nullable
    private final String comment;

    public SetColumnComment(NodeLocation location, QualifiedName table, Identifier field, boolean tableIfExists, boolean columnIfExists, @Nullable String comment) {
        super(Objects.requireNonNull(location, "location is null"));
        this.table = Objects.requireNonNull(table, "table is null");
        this.field = Objects.requireNonNull(field, "field is null");
        this.tableIfExists = tableIfExists;
        this.columnIfExists = columnIfExists;
        this.comment = comment;
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Identifier getField() {
        return this.field;
    }

    public boolean tableIfExists() {
        return this.tableIfExists;
    }

    public boolean columnIfExists() {
        return this.columnIfExists;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetColumnComment(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetColumnComment that = (SetColumnComment)o;
        return this.tableIfExists == that.tableIfExists && this.columnIfExists == that.columnIfExists && Objects.equals(this.table, that.table) && Objects.equals(this.field, that.field) && Objects.equals(this.comment, that.comment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.field, this.tableIfExists, this.columnIfExists, this.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("field", (Object)this.field).add("tableIfExists", this.tableIfExists).add("columnIfExists", this.columnIfExists).add("comment", (Object)this.comment).toString();
    }
}

