/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Match;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.PatternVisitor;

public class EqualsPattern<T>
extends Pattern<T> {
    private final T expectedValue;

    public EqualsPattern(T expectedValue, Optional<Pattern<?>> previous) {
        super(previous);
        this.expectedValue = Objects.requireNonNull(expectedValue, "expectedValue can't be null. Use isNull() pattern instead.");
    }

    public T expectedValue() {
        return this.expectedValue;
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        return Stream.of(Match.of(captures)).filter(match -> this.expectedValue.equals(object));
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitEquals(this);
    }
}

