/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.sys;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class SetSqlDialectStatement
extends Statement
implements IConfigStatement {
    private final IClientSession.SqlDialect sqlDialect;

    public SetSqlDialectStatement(IClientSession.SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public IClientSession.SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sqlDialect});
    }

    public String toString() {
        return "SET SQL_DIALECT=" + (Object)((Object)this.sqlDialect);
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitSetSqlDialect(this, context);
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        return AuthorityChecker.SUCCEED;
    }
}

