/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.logfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.ISerializer;

@NotThreadSafe
public class BufferedSerializer<T>
implements ISerializer<T> {
    private static final int INITIALIZED_BUFFER_SIZE = 8192;
    private final ByteArrayOutputStream logBufferStream = new ByteArrayOutputStream(8192);
    private final ISerializer<T> serializer;

    public BufferedSerializer(ISerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void serialize(T t, OutputStream outputStream) throws IOException {
        this.serializer.serialize(t, this.logBufferStream);
        this.logBufferStream.writeTo(outputStream);
        this.logBufferStream.reset();
    }
}

