/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionIoDataType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class CompactionMetrics
implements IMetricSet {
    private static final String NOT_ALIGNED = "not_aligned";
    private static final String ALIGNED = "aligned";
    private static final String METADATA = "metadata";
    private static final List<String> TYPES = Arrays.asList("aligned", "not_aligned");
    private static final CompactionMetrics INSTANCE = new CompactionMetrics();
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 10000L;
    private final AtomicInteger waitingSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingInsertionCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingSettleCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningInsertionCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningSettleCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishInsertionCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishSettleCompactionTaskNum = new AtomicInteger(0);
    private final Map<String, Counter[]> writeCounters = new ConcurrentHashMap<String, Counter[]>();
    private final Map<String, Counter[]> readCounters = new ConcurrentHashMap<String, Counter[]>();
    private Counter deserializeResourceCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalCompactedPointCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalCompactedChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalDirectlyFlushChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalDeserializedChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalMergedChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Timer seqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer unSeqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer crossCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer insertionCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer settleCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Histogram seqInnerSpaceCompactionTaskMemory = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram unseqInnerSpaceCompactionTaskMemory = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram crossSpaceCompactionTaskMemory = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram settleCompactionTaskMemory = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Gauge seqInnerSpaceCompactionTaskSelectedNum = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Gauge unseqInnerSpaceCompactionTaskSelectedNum = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Gauge crossInnerSpaceCompactionTaskSelectedNum = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Gauge insertionCrossSpaceCompactionTaskSelectedNum = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Gauge settleCompactionTaskSelectedNum = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Histogram seqSpaceCompactionTaskSelectionTimeCost = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram unseqSpaceCompactionTaskSelectionTimeCost = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram crossSpaceCompactionTaskSelectionTimeCost = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram insertionCrossSpaceCompactionTaskSelectionTimeCost = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram settleCompactionTaskSelectionTimeCost = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram seqInnerSpaceCompactionTaskSelectedFileNum = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram unseqInnerSpaceCompactionTaskSelectedFileNum = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram crossSpaceCompactionTaskSelectedFileNum = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram settleCompactionTaskSelectedFileNum = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram seqInnerSpaceCompactionTaskSelectedFileSize = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram unseqInnerSpaceCompactionTaskSelectedFileSize = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram crossSpaceCompactionTaskSelectedFileSize = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram insertionCrossSpaceCompactionTaskSelectedFileSize = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram settleCompactionTaskSelectedFileSize = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private final AtomicLong totalCachedDeviceTimeIndexSize = new AtomicLong(0L);

    private CompactionMetrics() {
        for (String type : TYPES) {
            this.readCounters.put(type, new Counter[]{DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER});
            this.writeCounters.put(type, new Counter[]{DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER});
        }
    }

    private void bindWriteInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            this.writeCounters.put(compactionType.toString(), new Counter[]{metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA})});
        }
    }

    private void unbindWriteInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA});
        }
    }

    public void recordWriteInfo(CompactionType compactionType, CompactionIoDataType dataType, long byteNum) {
        Counter[] counters = this.writeCounters.get(compactionType.toString());
        if (counters != null) {
            counters[dataType.getValue()].inc(byteNum);
        }
    }

    private void bindReadInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            this.readCounters.put(compactionType.toString(), new Counter[]{metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA})});
        }
        this.deserializeResourceCounter = metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), "total", Tag.NAME.toString(), "deserialize_resource"});
    }

    private void unbindReadInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA});
        }
        metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), "total", Tag.NAME.toString(), "deserialize_resource"});
    }

    public void recordReadInfo(CompactionType compactionType, CompactionIoDataType dataType, long byteNum) {
        Counter[] counters = this.readCounters.get(compactionType.toString());
        if (counters != null) {
            counters[dataType.getValue()].inc(byteNum);
        }
    }

    public void recordDeserializeResourceInfo(long byteNum) {
        this.deserializeResourceCounter.inc(byteNum);
    }

    private void bindPerformanceInfo(AbstractMetricService metricService) {
        this.totalCompactedPointCounter = metricService.getOrCreateCounter("compacted_point_num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalCompactedChunkCounter = metricService.getOrCreateCounter("compacted_chunk_num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalDirectlyFlushChunkCounter = metricService.getOrCreateCounter("directly_flush_chunk_num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalDeserializedChunkCounter = metricService.getOrCreateCounter("deserialized_chunk_num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalMergedChunkCounter = metricService.getOrCreateCounter("merged_chunk_num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
    }

    private void unbindPerformanceInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.COUNTER, "compacted_point_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "compacted_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "directly_flush_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "deserialized_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "merged_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
    }

    public void recordSummaryInfo(CompactionTaskSummary summary) {
        this.totalCompactedPointCounter.inc(summary.getProcessPointNum());
        this.totalCompactedChunkCounter.inc((long)summary.getProcessChunkNum());
        this.totalDirectlyFlushChunkCounter.inc((long)summary.getDirectlyFlushChunkNum());
        this.totalDeserializedChunkCounter.inc((long)summary.getDeserializeChunkCount());
        this.totalMergedChunkCounter.inc((long)summary.getMergedChunkNum());
    }

    public void recordTaskFinishOrAbort(CompactionTaskType type, long timeCost) {
        switch (type) {
            case CROSS: {
                this.finishCrossCompactionTaskNum.incrementAndGet();
                this.crossCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
                break;
            }
            case INSERTION: {
                this.finishInsertionCompactionTaskNum.incrementAndGet();
                this.insertionCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
                break;
            }
            case INNER_SEQ: {
                this.finishSeqInnerCompactionTaskNum.incrementAndGet();
                this.seqCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
                break;
            }
            case INNER_UNSEQ: {
                this.finishUnseqInnerCompactionTaskNum.incrementAndGet();
                this.unSeqCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
                break;
            }
            case SETTLE: {
                this.finishSettleCompactionTaskNum.incrementAndGet();
                this.settleCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void bindTaskInfo(AbstractMetricService metricService) {
        this.seqCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "inner_seq_compaction"});
        this.unSeqCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "inner_unseq_compaction"});
        this.crossCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "cross_compaction"});
        this.insertionCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "insertion_compaction"});
        this.settleCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "settle_compaction"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingCrossCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingInsertionCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_insertion", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingSeqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingUnseqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingSettleCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_settle", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningCrossCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningInsertionCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_insertion", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningSeqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningUnseqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningSettleCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_settle", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishSeqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "inner_seq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishUnseqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "inner_unseq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishCrossCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "cross"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishInsertionCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "insertion"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishSettleCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "settle"});
    }

    private void unbindTaskInfo(AbstractMetricService metricService) {
        this.seqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.unSeqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.crossCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.settleCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        for (String taskType : Arrays.asList("inner_seq_compaction", "inner_unseq_compaction", "cross_compaction", "insertion_compaction", "settle_compaction")) {
            metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), taskType});
        }
        for (String taskType : Arrays.asList("compaction_cross", "compaction_insertion", "compaction_inner_seq", "compaction_inner_unseq", "compaction_settle")) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), taskType, Tag.STATUS.toString(), "waiting"});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), taskType, Tag.STATUS.toString(), "running"});
        }
        for (String taskType : Arrays.asList("inner_seq", "inner_unseq", "cross", "insertion", "settle")) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), taskType});
        }
    }

    public void updateCompactionMemoryMetrics(CompactionTaskType taskType, long memory) {
        switch (taskType) {
            case INNER_SEQ: {
                this.seqInnerSpaceCompactionTaskMemory.update(memory);
                break;
            }
            case INNER_UNSEQ: {
                this.unseqInnerSpaceCompactionTaskMemory.update(memory);
                break;
            }
            case CROSS: {
                this.crossSpaceCompactionTaskMemory.update(memory);
                break;
            }
            case SETTLE: {
                this.settleCompactionTaskMemory.update(memory);
                break;
            }
        }
    }

    private void bindCompactionTaskMemory(AbstractMetricService metricService) {
        this.seqInnerSpaceCompactionTaskMemory = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_MEMORY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "seq"});
        this.unseqInnerSpaceCompactionTaskMemory = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_MEMORY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unseq"});
        this.crossSpaceCompactionTaskMemory = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_MEMORY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross"});
        this.settleCompactionTaskMemory = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_MEMORY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "settle"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> SystemInfo.getInstance().getCompactionMemoryBlock().getUsedMemoryInBytes(), new String[]{Tag.NAME.toString(), "total_usage"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> SystemInfo.getInstance().getSeqInnerSpaceCompactionMemoryCost().get(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> SystemInfo.getInstance().getUnseqInnerSpaceCompactionMemoryCost().get(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> SystemInfo.getInstance().getCrossSpaceCompactionMemoryCost().get(), new String[]{Tag.NAME.toString(), "cross"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> SystemInfo.getInstance().getSettleCompactionMemoryCost().get(), new String[]{Tag.NAME.toString(), "settle"});
    }

    private void unbindCompactionTaskMemory(AbstractMetricService metricService) {
        for (String taskType : Arrays.asList("seq", "unseq", "cross", "settle")) {
            metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_MEMORY.toString(), new String[]{Tag.NAME.toString(), taskType});
        }
        for (String taskType : Arrays.asList("seq", "unseq", "cross", "settle", "total")) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), new String[]{Tag.NAME.toString(), taskType});
        }
    }

    public void addSelectionCachedDeviceTimeIndexSize(long size) {
        this.totalCachedDeviceTimeIndexSize.addAndGet(size);
    }

    public void decreaseSelectionCachedDeviceTimeIndexSize(long size) {
        this.totalCachedDeviceTimeIndexSize.addAndGet(-size);
    }

    public void updateCompactionTaskSelectionNum(CompactionScheduleContext context) {
        this.seqInnerSpaceCompactionTaskSelectedNum.set((long)context.getSubmitSeqInnerSpaceCompactionTaskNum());
        this.unseqInnerSpaceCompactionTaskSelectedNum.set((long)context.getSubmitUnseqInnerSpaceCompactionTaskNum());
        this.crossInnerSpaceCompactionTaskSelectedNum.set((long)context.getSubmitCrossSpaceCompactionTaskNum());
        this.insertionCrossSpaceCompactionTaskSelectedNum.set((long)context.getSubmitInsertionCrossSpaceCompactionTaskNum());
        this.settleCompactionTaskSelectedNum.set((long)context.getSubmitSettleCompactionTaskNum());
    }

    public void updateCompactionTaskSelectionTimeCost(CompactionTaskType taskType, long time) {
        switch (taskType) {
            case INNER_SEQ: {
                this.seqSpaceCompactionTaskSelectionTimeCost.update(time);
                break;
            }
            case INNER_UNSEQ: {
                this.unseqSpaceCompactionTaskSelectionTimeCost.update(time);
                break;
            }
            case CROSS: {
                this.crossSpaceCompactionTaskSelectionTimeCost.update(time);
                break;
            }
            case INSERTION: {
                this.insertionCrossSpaceCompactionTaskSelectionTimeCost.update(time);
                break;
            }
            case SETTLE: {
                this.settleCompactionTaskSelectionTimeCost.update(time);
                break;
            }
        }
    }

    public void updateCompactionTaskSelectedFileNum(CompactionTaskType taskType, int selectedFileNum) {
        switch (taskType) {
            case INNER_SEQ: {
                this.seqInnerSpaceCompactionTaskSelectedFileNum.update((long)selectedFileNum);
                break;
            }
            case INNER_UNSEQ: {
                this.unseqInnerSpaceCompactionTaskSelectedFileNum.update((long)selectedFileNum);
                break;
            }
            case CROSS: {
                this.crossSpaceCompactionTaskSelectedFileNum.update((long)selectedFileNum);
                break;
            }
            case SETTLE: {
                this.settleCompactionTaskSelectedFileNum.update((long)selectedFileNum);
                break;
            }
        }
    }

    public void updateCompactionTaskSelectedFileSize(CompactionTaskType taskType, long size) {
        switch (taskType) {
            case INNER_SEQ: {
                this.seqInnerSpaceCompactionTaskSelectedFileSize.update(size);
                break;
            }
            case INNER_UNSEQ: {
                this.unseqInnerSpaceCompactionTaskSelectedFileSize.update(size);
                break;
            }
            case CROSS: {
                this.crossSpaceCompactionTaskSelectedFileSize.update(size);
                break;
            }
            case SETTLE: {
                this.settleCompactionTaskSelectedFileSize.update(size);
                break;
            }
            case INSERTION: {
                this.insertionCrossSpaceCompactionTaskSelectedFileSize.update(size);
            }
        }
    }

    private void bindCompactionTaskSelection(AbstractMetricService metricService) {
        this.seqInnerSpaceCompactionTaskSelectedNum = metricService.getOrCreateGauge(Metric.COMPACTION_TASK_SELECTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "seq"});
        this.unseqInnerSpaceCompactionTaskSelectedNum = metricService.getOrCreateGauge(Metric.COMPACTION_TASK_SELECTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unseq"});
        this.crossInnerSpaceCompactionTaskSelectedNum = metricService.getOrCreateGauge(Metric.COMPACTION_TASK_SELECTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross"});
        this.insertionCrossSpaceCompactionTaskSelectedNum = metricService.getOrCreateGauge(Metric.COMPACTION_TASK_SELECTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "insertion"});
        this.settleCompactionTaskSelectedNum = metricService.getOrCreateGauge(Metric.COMPACTION_TASK_SELECTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "settle"});
        this.seqSpaceCompactionTaskSelectionTimeCost = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "seq"});
        this.unseqSpaceCompactionTaskSelectionTimeCost = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unseq"});
        this.crossSpaceCompactionTaskSelectionTimeCost = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross"});
        this.insertionCrossSpaceCompactionTaskSelectionTimeCost = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "insertion"});
        this.settleCompactionTaskSelectionTimeCost = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "settle"});
        this.seqInnerSpaceCompactionTaskSelectedFileNum = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "seq"});
        this.unseqInnerSpaceCompactionTaskSelectedFileNum = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unseq"});
        this.crossSpaceCompactionTaskSelectedFileNum = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross"});
        this.settleCompactionTaskSelectedFileNum = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "settle"});
        this.seqInnerSpaceCompactionTaskSelectedFileSize = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "seq"});
        this.unseqInnerSpaceCompactionTaskSelectedFileSize = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unseq"});
        this.crossSpaceCompactionTaskSelectedFileSize = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross"});
        this.insertionCrossSpaceCompactionTaskSelectedFileSize = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "insertion"});
        this.settleCompactionTaskSelectedFileSize = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "settle"});
        metricService.createAutoGauge(Metric.COMPACTION_SELECTION_CACHED_TIME_INDEX_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> this.totalCachedDeviceTimeIndexSize.get(), new String[]{Tag.NAME.toString(), "total_cached_device_time_index_size"});
    }

    private void unbindCompactionTaskSelection(AbstractMetricService metricService) {
        for (String taskType : Arrays.asList("seq", "unseq", "cross", "insertion", "settle")) {
            metricService.remove(MetricType.GAUGE, Metric.COMPACTION_TASK_SELECTION.toString(), new String[]{Tag.NAME.toString(), taskType});
            metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_SELECTION_COST.toString(), new String[]{Tag.NAME.toString(), taskType});
        }
        for (String taskType : Arrays.asList("seq", "unseq", "cross", "settle")) {
            metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_SELECTED_FILE.toString(), new String[]{Tag.NAME.toString(), taskType});
        }
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_SELECTION_CACHED_TIME_INDEX_SIZE.toString(), new String[]{Tag.NAME.toString(), "total_cached_device_time_index_size"});
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindTaskInfo(metricService);
        this.bindWriteInfo(metricService);
        this.bindReadInfo(metricService);
        this.bindPerformanceInfo(metricService);
        this.bindCompactionTaskMemory(metricService);
        this.bindCompactionTaskSelection(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindTaskInfo(metricService);
        this.unbindWriteInfo(metricService);
        this.unbindReadInfo(metricService);
        this.unbindPerformanceInfo(metricService);
        this.unbindCompactionTaskMemory(metricService);
        this.unbindCompactionTaskSelection(metricService);
    }

    private void updateCompactionTaskInfo() {
        if (System.currentTimeMillis() - this.lastUpdateTime < 10000L) {
            return;
        }
        this.lastUpdateTime = System.currentTimeMillis();
        Map<CompactionTaskType, Map<CompactionTaskStatus, Integer>> compactionTaskStatisticMap = CompactionTaskManager.getInstance().getCompactionTaskStatistic();
        this.waitingSeqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_SEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingUnseqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_UNSEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingCrossCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.CROSS, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingInsertionCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INSERTION, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingSettleCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.SETTLE, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.runningSeqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_SEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningUnseqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_UNSEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningCrossCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.CROSS, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningInsertionCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INSERTION, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningSettleCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.SETTLE, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
    }

    public static CompactionMetrics getInstance() {
        return INSTANCE;
    }
}

