/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.disk;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategy;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.MaxDiskUsableSpaceFirstStrategy;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.MinFolderOccupiedSpaceFirstStrategy;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.RandomOnDiskUsableSpaceStrategy;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.SequenceStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderManager {
    private static final Logger logger = LoggerFactory.getLogger(FolderManager.class);
    private final List<String> folders;
    private final Map<String, FolderState> foldersStates = new HashMap<String, FolderState>();
    private final DirectoryStrategy selectStrategy;

    public FolderManager(List<String> folders, DirectoryStrategyType type) throws DiskSpaceInsufficientException {
        this.folders = folders;
        folders.forEach(dir -> this.foldersStates.put((String)dir, FolderState.HEALTHY));
        switch (type) {
            case SEQUENCE_STRATEGY: {
                this.selectStrategy = new SequenceStrategy();
                break;
            }
            case MAX_DISK_USABLE_SPACE_FIRST_STRATEGY: {
                this.selectStrategy = new MaxDiskUsableSpaceFirstStrategy();
                break;
            }
            case MIN_FOLDER_OCCUPIED_SPACE_FIRST_STRATEGY: {
                this.selectStrategy = new MinFolderOccupiedSpaceFirstStrategy();
                break;
            }
            case RANDOM_ON_DISK_USABLE_SPACE_STRATEGY: {
                this.selectStrategy = new RandomOnDiskUsableSpaceStrategy();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        try {
            this.selectStrategy.setFolders(folders);
            this.selectStrategy.setFoldersStates(this.foldersStates);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("All folders are full, change system mode to read-only.", (Throwable)((Object)e));
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
            CommonDescriptor.getInstance().getConfig().setStatusReason("DiskFull");
            throw e;
        }
    }

    public void updateFolderState(String folder, FolderState state) {
        this.foldersStates.replace(folder, state);
        this.selectStrategy.updateFolderState(folder, state);
    }

    public String getNextFolder() throws DiskSpaceInsufficientException {
        try {
            return this.folders.get(this.selectStrategy.nextFolderIndex());
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("All folders are full, change system mode to read-only.", (Throwable)((Object)e));
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
            CommonDescriptor.getInstance().getConfig().setStatusReason("DiskFull");
            throw e;
        }
    }

    boolean hasHealthyFolder() {
        return this.folders.stream().anyMatch(folder -> this.foldersStates.getOrDefault(folder, FolderState.ABNORMAL) == FolderState.HEALTHY);
    }

    public <T, E extends Exception> T getNextWithRetry(ThrowingFunction<String, T, E> folderConsumer) throws DiskSpaceInsufficientException {
        String folder = null;
        while (this.hasHealthyFolder()) {
            try {
                folder = this.folders.get(this.selectStrategy.nextFolderIndex());
            }
            catch (DiskSpaceInsufficientException e) {
                logger.error("All folders are full, change system mode to read-only.", (Throwable)((Object)e));
                CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
                CommonDescriptor.getInstance().getConfig().setStatusReason("DiskFull");
                throw e;
            }
            try {
                return folderConsumer.apply(folder);
            }
            catch (Exception e) {
                this.updateFolderState(folder, FolderState.ABNORMAL);
                logger.warn("Failed to process folder '" + folder);
            }
        }
        throw new DiskSpaceInsufficientException(this.folders);
    }

    public List<String> getFolders() {
        return this.folders;
    }

    public static enum FolderState {
        HEALTHY,
        ABNORMAL;

    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

