/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.pipe;

import com.google.common.base.MoreObjects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTsFileEventBatch;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEvents;

public class SubscriptionPipeTsFileBatchEvents
implements SubscriptionPipeEvents {
    private final SubscriptionPipeTsFileEventBatch batch;
    private final AtomicInteger ackReferenceCount;
    private final AtomicInteger cleanReferenceCount;
    private final int count;

    public SubscriptionPipeTsFileBatchEvents(SubscriptionPipeTsFileEventBatch batch, AtomicInteger ackReferenceCount, AtomicInteger cleanReferenceCount) {
        this.batch = batch;
        this.ackReferenceCount = ackReferenceCount;
        this.cleanReferenceCount = cleanReferenceCount;
        this.count = Math.max(1, ackReferenceCount.get());
    }

    @Override
    public void ack() {
        if (this.ackReferenceCount.decrementAndGet() == 0) {
            this.batch.ack();
        }
    }

    @Override
    public void cleanUp(boolean force) {
        if (this.cleanReferenceCount.decrementAndGet() == 0) {
            this.batch.cleanUp(force);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("batch", (Object)this.batch).add("count", this.count).toString();
    }

    @Override
    public int getPipeEventCount() {
        return (this.batch.getPipeEventCount() + this.count - 1) / this.count;
    }
}

